% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate-process.R
\name{sim_vhar}
\alias{sim_vhar}
\title{Generate Multivariate Time Series Process Following VAR(p)}
\usage{
sim_vhar(
  num_sim,
  num_burn,
  vhar_coef,
  week = 5L,
  month = 22L,
  sig_error = diag(ncol(vhar_coef)),
  init = matrix(0L, nrow = month, ncol = ncol(vhar_coef)),
  method = c("eigen", "chol"),
  process = c("gaussian", "student"),
  t_param = 5
)
}
\arguments{
\item{num_sim}{Number to generated process}

\item{num_burn}{Number of burn-in}

\item{vhar_coef}{VAR coefficient. The format should be the same as the output of \code{\link[=coef.varlse]{coef.varlse()}} from \code{\link[=var_lm]{var_lm()}}}

\item{week}{Weekly order of VHAR. By default, \code{5}.}

\item{month}{Weekly order of VHAR. By default, \code{22}.}

\item{sig_error}{Variance matrix of the error term. By default, \code{diag(dim)}.}

\item{init}{Initial y1, ..., yp matrix to simulate VAR model. Try \code{matrix(0L, nrow = month, ncol = dim)}.}

\item{method}{Method to compute \eqn{\Sigma^{1/2}}.
Choose between \code{"eigen"} (spectral decomposition) and \code{"chol"} (cholesky decomposition).
By default, \code{"eigen"}.}

\item{process}{Process to generate error term.
\code{"gaussian"}: Normal distribution (default) or \code{"student"}: Multivariate t-distribution.}

\item{t_param}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} argument for MVT, e.g. DF: 5.}
}
\value{
T x k matrix
}
\description{
This function generates multivariate time series dataset that follows VAR(p).
}
\details{
Let \eqn{M} be the month order, e.g. \eqn{M = 22}.
\enumerate{
\item Generate \eqn{\epsilon_1, \epsilon_n \sim N(0, \Sigma)}
\item For i = 1, ... n,
\deqn{y_{M + i} = (y_{M + i - 1}^T, \ldots, y_i^T, 1)^T C_{HAR}^T \Phi + \epsilon_i}
\item Then the output is \eqn{(y_{M + 1}, \ldots, y_{n + M})^T}
\item For i = 1, ... n,
\deqn{y_{p + i} = (y_{p + i - 1}^T, \ldots, y_i^T, 1)^T B + \epsilon_i}
\item Then the output is \eqn{(y_{p + 1}, \ldots, y_{n + p})^T}
}

Initial values might be set to be zero vector or \eqn{(I_m - A_1 - \cdots - A_p)^{-1} c}.
}
\references{
Lütkepohl, H. (2007). \emph{New Introduction to Multiple Time Series Analysis}. Springer Publishing.
}
