% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_excel_sheets_to_csv.R
\name{write_excel_sheets_to_csv}
\alias{write_excel_sheets_to_csv}
\title{Export Excel Sheets to CSV Files}
\usage{
write_excel_sheets_to_csv(excel_path, output_dir = "data/")
}
\arguments{
\item{excel_path}{A character string specifying the path to the Excel file.}

\item{output_dir}{A character string specifying the directory where CSV files will be saved.
Defaults to "data/".}
}
\value{
A list of file paths corresponding to the exported CSV files.
}
\description{
This function reads an Excel file, converts each sheet into a data frame, and writes each sheet
to a CSV file in the specified output directory.
}
\examples{
# Path to the example Excel file shipped with the package
excel_file <- system.file("extdata", "Diamonds.xlsx", package = "bulkreadr")

# Export each sheet to its own CSV in a temporary directory
output_dir <- tempdir()
write_excel_sheets_to_csv(excel_file, output_dir)

}
