% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_regime_probabilities.R
\name{compute_regime_probabilities.PosteriorBSVARMSH}
\alias{compute_regime_probabilities.PosteriorBSVARMSH}
\title{Computes posterior draws of regime probabilities}
\usage{
\method{compute_regime_probabilities}{PosteriorBSVARMSH}(
  posterior,
  type = c("realized", "filtered", "forecasted", "smoothed")
)
}
\arguments{
\item{posterior}{posterior estimation outcome - an object of class 
\code{PosteriorBSVARMSH} obtained by running the \code{estimate} function.}

\item{type}{one of the values \code{"realized"}, \code{"filtered"}, \code{"forecasted"}, or \code{"smoothed"}
denoting the type of probabilities to be computed.}
}
\value{
An object of class PosteriorRegimePr, that is, an \code{MxTxS} array with attribute PosteriorRegimePr 
containing \code{S} draws of the regime probabilities.
}
\description{
Each of the draws from the posterior estimation of a model is transformed into
a draw from the posterior distribution of the regime probabilities. These represent either
the realisations of the regime indicators, when \code{type = "realized"}, filtered probabilities,
when \code{type = "filtered"}, forecasted regime probabilities, when \code{type = "forecasted"},
or the smoothed probabilities, when \code{type = "smoothed"}, .
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
set.seed(123)
specification  = specify_bsvar_msh$new(us_fiscal_lsuw, p = 2, M = 2)

# run the burn-in
burn_in        = estimate(specification, 10)

# estimate the model
posterior      = estimate(burn_in, 20)

# compute the posterior draws of realized regime indicators
regimes        = compute_regime_probabilities(posterior)

# compute the posterior draws of filtered probabilities
filtered       = compute_regime_probabilities(posterior, "filtered")

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_msh$new(p = 1, M = 2) |>
  estimate(S = 10) |> 
  estimate(S = 20) -> posterior
regimes        = compute_regime_probabilities(posterior)
filtered       = compute_regime_probabilities(posterior, "filtered")

}
\references{
Song, Y., and Woźniak, T., (2021) Markov Switching. \emph{Oxford Research Encyclopedia of Economics and Finance}, Oxford University Press, \doi{10.1093/acrefore/9780190625979.013.174}.
}
\seealso{
\code{\link{estimate}}, \code{\link{summary}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
