% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.PosteriorIR}
\alias{plot.PosteriorIR}
\title{Plots impulse responses}
\usage{
\method{plot}{PosteriorIR}(
  x,
  probability = 0.9,
  col = "#ff69b4",
  main,
  xlab,
  mar.multi = c(1, 4.1, 0, 1.1),
  oma.multi = c(6, 0, 5, 0),
  ...
)
}
\arguments{
\item{x}{an object of class PosteriorIR obtained using the
\code{compute_impulse_responses()} function containing posterior draws of 
impulse responses.}

\item{probability}{a parameter determining the interval to be plotted. The 
interval stretches from the \code{0.5 * (1 - probability)} to 
\code{1 - 0.5 * (1 - probability)} percentile of the posterior distribution.}

\item{col}{a colour of the plot line and the ribbon}

\item{main}{an alternative main title for the plot}

\item{xlab}{an alternative x-axis label for the plot}

\item{mar.multi}{the default \code{mar} argument setting in \code{graphics::par}. Modify with care!}

\item{oma.multi}{the default \code{oma} argument setting in \code{graphics::par}. Modify with care!}

\item{...}{additional arguments affecting the summary produced.}
}
\description{
Plots of of all variables to all shocks including their 
median and percentiles.
}
\examples{
data(us_fiscal_lsuw)                                  # upload data
set.seed(123)                                         # set seed
specification  = specify_bsvar$new(us_fiscal_lsuw)    # specify model
burn_in        = estimate(specification, 10)          # run the burn-in
posterior      = estimate(burn_in, 20, thin = 1)      # estimate the model

# compute impulse responses
fitted         = compute_impulse_responses(posterior, horizon = 4)
plot(fitted)                                          # plot

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar$new() |>
  estimate(S = 10) |> 
  estimate(S = 20, thin = 1) |> 
  compute_impulse_responses(horizon = 4) |>
  plot()

}
\seealso{
\code{\link{compute_impulse_responses}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
