% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_impulse_responses.R
\name{compute_impulse_responses}
\alias{compute_impulse_responses}
\title{Computes posterior draws of impulse responses}
\usage{
compute_impulse_responses(posterior, horizon, standardise = FALSE)
}
\arguments{
\item{posterior}{posterior estimation outcome - an object of either of the classes: 
PosteriorBSVAR, PosteriorBSVARMSH, PosteriorBSVARMIX, or PosteriorBSVARSV
obtained by running the \code{estimate} function. The interpretation depends on the normalisation of the shocks
using function \code{normalise_posterior()}. Verify if the default settings are appropriate.}

\item{horizon}{a positive integer number denoting the forecast horizon for the impulse responses computations.}

\item{standardise}{a logical value. If \code{TRUE}, the impulse responses are standardised 
so that the variables' own shocks at horizon 0 are equal to 1. Otherwise, the parameter estimates 
determine this magnitude.}
}
\value{
An object of class PosteriorIR, that is, an \code{NxNx(horizon+1)xS} array with attribute PosteriorIR 
containing \code{S} draws of the impulse responses.
}
\description{
Each of the draws from the posterior estimation of a model is transformed into
a draw from the posterior distribution of the impulse responses.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
set.seed(123)
specification  = specify_bsvar$new(us_fiscal_lsuw, p = 1)

# run the burn-in
burn_in        = estimate(specification, 10)

# estimate the model
posterior      = estimate(burn_in, 50)

# compute impulse responses 2 years ahead
irf           = compute_impulse_responses(posterior, horizon = 8)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar$new(p = 1) |>
  estimate(S = 10) |> 
  estimate(S = 50) |> 
  compute_impulse_responses(horizon = 8) -> ir

}
\references{
Kilian, L., & Lütkepohl, H. (2017). Structural VAR Tools, Chapter 4, In: Structural vector autoregressive analysis. Cambridge University Press.
}
\seealso{
\code{\link{estimate}}, \code{\link{normalise_posterior}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
