% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_historical_decompositions.R
\name{compute_historical_decompositions}
\alias{compute_historical_decompositions}
\title{Computes posterior draws of historical decompositions}
\usage{
compute_historical_decompositions(posterior)
}
\arguments{
\item{posterior}{posterior estimation outcome - an object of either of the classes: 
PosteriorBSVAR, PosteriorBSVARMSH, PosteriorBSVARMIX, or PosteriorBSVARSV
obtained by running the \code{estimate} function. The interpretation depends on the normalisation of the shocks
using function \code{normalise_posterior()}. Verify if the default settings are appropriate.}
}
\value{
An object of class PosteriorHD, that is, an \code{NxNxTxS} array with attribute PosteriorHD 
containing \code{S} draws of the historical decompositions.
}
\description{
Each of the draws from the posterior estimation of a model is transformed into
a draw from the posterior distribution of the historical decompositions.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
set.seed(123)
specification  = specify_bsvar$new(us_fiscal_lsuw, p = 1)

# run the burn-in
burn_in        = estimate(specification, 10)

# estimate the model
posterior      = estimate(burn_in, 50)

# compute historical decompositions
hd            = compute_historical_decompositions(posterior)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar$new(p = 1) |>
  estimate(S = 50) |> 
  estimate(S = 100) |> 
  compute_historical_decompositions() -> hd

}
\references{
Kilian, L., & Lütkepohl, H. (2017). Structural VAR Tools, Chapter 4, In: Structural vector autoregressive analysis. Cambridge University Press.
}
\seealso{
\code{\link{estimate}}, \code{\link{normalise_posterior}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
