% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bssm-package.R
\docType{package}
\name{bssm}
\alias{bssm}
\title{Bayesian Inference of State Space Models}
\description{
This package contains functions for efficient Bayesian inference of state
space models (SSMs), where model is assumed to be either
}
\details{
\itemize{
\item Exponential family state space models, where the state equation is linear
Gaussian, and the conditional observation density is either Gaussian,
Poisson, binomial, negative binomial or Gamma density.
\item Basic stochastic volatility model.
\item General non-linear model with Gaussian noise terms.
\item Model with continuous SDE dynamics.
}

Missing values in response series are allowed as per SSM theory and can be
automatically predicted, but there can be no missing values in the system
matrices of the model.

The \code{bssm} package includes several MCMC sampling and sequential Monte
Carlo methods for models outside classic linear-Gaussian framework. For
definitions of the currently supported models and methods, usage of the
package as well as some theory behind the novel IS-MCMC and
\eqn{\psi}{psi}-APF algorithms, see Helske and Vihola (2021), Vihola,
Helske, Franks (2020), and the package vignettes.
}
\examples{
model <- bsm_lg(Nile,
  sd_y = tnormal(init = 100, mean = 100, sd = 100, min = 0),
  sd_level = tnormal(init = 50, mean = 50, sd = 100, min = 0),
  a1 = 1000, P1 = 500^2)

fit <- run_mcmc(model, iter = 2000)
fit
}
\references{
Helske J, Vihola M (2021). bssm: Bayesian Inference of Non-linear and
Non-Gaussian State Space Models in R. The R Journal (2021) 13:2, 578-589.
https://doi.org/10.32614/RJ-2021-103

Vihola, M, Helske, J, Franks, J. (2020). Importance sampling type estimators
based on approximate marginal Markov chain Monte Carlo.
Scand J Statist. 1-38. https://doi.org/10.1111/sjos.12492
}
