% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel.R
\name{bs_panel}
\alias{bs_panel}
\title{Panel}
\usage{
bs_panel(
  id = NULL,
  panel_type = c("default", "primary", "success", "info", "warning", "danger"),
  heading = NULL,
  body = NULL,
  ...,
  footer = NULL
)
}
\arguments{
\item{id}{character, unique identifier}

\item{panel_type}{character, one of the standard Bootstrap types}

\item{heading}{character (HTML) or \link[htmltools:builder]{htmltools::tagList()},
content for the heading}

\item{body}{character (HTML) or \link[htmltools:builder]{htmltools::tagList()},
content for the body}

\item{...}{character (HTML) or \link[htmltools:builder]{htmltools::tagList()},
other content}

\item{footer}{character (HTML) or \link[htmltools:builder]{htmltools::tagList()},
content for the footer}
}
\value{
Object with S3 class, \code{shiny.tag}, \verb{<div/>}
}
\description{
This function makes it a little easier to make Bootstrap-friendly panels;
it wraps \code{\link[htmltools:builder]{htmltools::tags}} for panels
}
\examples{
library("htmltools")

bs_panel(
  panel_type = "primary",
  heading = tags$h3("title"),
  body = tags$p("Some very important content")
)
}
\seealso{
\url{https://getbootstrap.com/docs/3.3/css/#panels}
}
