% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multinom_tidiers.R
\name{multinom_tidiers}
\alias{glance.multinom}
\alias{multinom_tidiers}
\alias{tidy.multinom}
\title{Tidying methods for multinomial logistic regression models}
\usage{
\method{tidy}{multinom}(x, conf.int = FALSE, conf.level = 0.95,
  exponentiate = TRUE, ...)

\method{glance}{multinom}(x, ...)
}
\arguments{
\item{x}{A model object of class \code{multinom}}

\item{conf.int}{whether to include a confidence interval}

\item{conf.level}{confidence level of the interval, used only if
\code{conf.int=TRUE}}

\item{exponentiate}{whether to exponentiate the coefficient estimates
and confidence intervals (typical for multinomial logistic regression)}

\item{...}{extra arguments, not used}
}
\value{
All tidying methods return a \code{data.frame} without rownames.
The structure depends on the method chosen.

\code{tidy.multinom} returns one row for each coefficient at each 
level of the response variable, with six columns:
  \item{y.value}{The response level}
  \item{term}{The term in the model being estimated and tested}
  \item{estimate}{The estimated coefficient}
  \item{std.error}{The standard error from the linear model}
  \item{statistic}{Wald z-statistic}
  \item{p.value}{two-sided p-value}

If \code{conf.int=TRUE}, it also includes columns for \code{conf.low} and
\code{conf.high}, computed with \code{\link{confint}}.

\code{glance.multinom} returns a

\code{glance.multinom} returns a one-row data.frame with the columns
  \item{edf}{The effective degrees of freedom}
  \item{deviance}{deviance}
  \item{AIC}{the Akaike Information Criterion}
}
\description{
These methods tidy the coefficients of multinomial logistic regression 
models generated by \code{multinom} of the \code{nnet} package.
}
\details{
If \code{conf.int=TRUE}, the confidence interval is computed with
the \code{\link{confint}} function.

While \code{tidy} and \code{glance} are supported for "multinom" objects, 
\code{augment} is not.
}
\examples{

if (require(nnet) & require(MASS)){
  example(birthwt)
  bwt.mu <- multinom(low ~ ., bwt)
  tidy(bwt.mu)
  glance(bwt.mu)
  
  #* This model is a truly terrible model
  #* but it should show you what the output looks
  #* like in a multinomial logistic regression
  
  fit.gear <- multinom(gear ~ mpg + factor(am), data=mtcars)
  tidy(fit.gear)
  glance(fit.gear)
}
  
}

