% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{ranef.brmsfit}
\alias{ranef}
\alias{ranef.brmsfit}
\title{Extract Group-Level Estimates}
\usage{
\method{ranef}{brmsfit}(object, estimate = c("mean", "median"), var = FALSE,
  ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{estimate}{The point estimate to be calculated 
for the group-level effects, either \code{"mean"} or \code{"median"}.}

\item{var}{logical; indicating if the covariance matrix 
for each group-level effects should be computed.}

\item{...}{Further arguments to be passed to the function 
specified in \code{estimate}.}
}
\value{
A list of matrices (one per grouping factor), 
 with factor levels as row names and 
 group-level effects as column names.
}
\description{
Extract the group-level ('random') effects of each level 
from a \code{brmsfit} object.
}
\examples{
\dontrun{
fit <- brm(count ~ log_Age_c + log_Base4_c * Trt_c + (1+Trt_c|visit), 
           data = epilepsy, family = "poisson", chains = 1)
## group-level means with corresponding covariances
rf <- ranef(fit, var = TRUE)
attr(rf, "var")
## group-level medians
ranef(fit, estimate = "median")                                                        
}

}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}

