% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/generics.R
\name{log_posterior.brmsfit}
\alias{diagnostic-quantities}
\alias{log_posterior}
\alias{log_posterior.brmsfit}
\alias{neff_ratio}
\alias{neff_ratio.brmsfit}
\alias{nuts_params}
\alias{nuts_params.brmsfit}
\alias{rhat}
\alias{rhat.brmsfit}
\title{Extract Diagnostic Quantities of \pkg{brms} Models}
\usage{
\method{log_posterior}{brmsfit}(object, ...)

\method{nuts_params}{brmsfit}(object, pars = NULL, ...)

\method{rhat}{brmsfit}(object, pars = NULL, ...)

\method{neff_ratio}{brmsfit}(object, pars = NULL, ...)
}
\arguments{
\item{object}{A \code{brmsfit} object.}

\item{...}{Arguments passed to individual methods.}

\item{pars}{An optional character vector of parameter names. 
For \code{nuts_params} these will be NUTS sampler parameter 
names rather than model parameters. If pars is omitted 
all parameters are included.}
}
\value{
The exact form of the output depends on the method.
}
\description{
Extract quantities that can be used to diagnose sampling behavior
of the algorithms applied by \pkg{Stan} at the back-end of \pkg{brms}.
}
\details{
For more details see 
  \code{\link[bayesplot:bayesplot-extractors]{bayesplot-extractors}}.
}
\examples{
\dontrun{
fit <- brm(time ~ age * sex, data = kidney)

lp <- log_posterior(fit)
head(lp)

np <- nuts_params(fit)
str(np)
# extract the number of divergence transitions
sum(subset(np, Parameter == "divergent__")$Value)

head(rhat(fit))
head(neff_ratio(fit))
}
}

