% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORI.R
\name{devianceOR1}
\alias{devianceOR1}
\title{Deviance Information Criterion for OR1 model}
\usage{
devianceOR1(y, x, betadraws, deltadraws, postMeanbeta, postMeandelta, burn, mcmc, p)
}
\arguments{
\item{y}{observed ordinal outcomes, column vector of size \eqn{(n x 1)}.}

\item{x}{covariate matrix of size \eqn{(n x k)} including a column of ones with or without column names.}

\item{betadraws}{MCMC draws of \eqn{\beta}, size is \eqn{(k x nsim)}.}

\item{deltadraws}{MCMC draws of \eqn{\delta}, size is \eqn{((J-2) x nsim)}.}

\item{postMeanbeta}{posterior mean of the MCMC draws of \eqn{\beta}.}

\item{postMeandelta}{posterior mean of the MCMC draws of \eqn{\delta}.}

\item{burn}{number of burn-in MCMC iterations.}

\item{mcmc}{number of MCMC iterations, post burn-in.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns a list with components
\deqn{DIC = 2*avgdDeviance - devpostmean}
\deqn{pd = avgdDeviance - devpostmean}
\deqn{devpostmean = -2*(logLikelihood)}.
}
\description{
Function for computing the Deviance Information Criterion (DIC) for OR1 model (ordinal quantile
model with 3 or more outcomes).
}
\details{
Deviance is -2*(log likelihood) and has an important role in
statistical model comparison because of its relation with Kullback-Leibler
information criterion.

This function provides the DIC, which can be used to compare two or more models at the
same quantile. The model with a lower DIC provides a better fit.
}
\examples{
set.seed(101)
data("data25j4")
y <- data25j4$y
xMat <- data25j4$x
k <- dim(xMat)[2]
J <- dim(as.array(unique(y)))[1]
b0 <- array(rep(0, k), dim = c(k, 1))
B0 <- 10*diag(k)
d0 <- array(0, dim = c(J-2, 1))
D0 <- 0.25*diag(J - 2)
output <- quantregOR1(y = y, x = xMat, b0, B0, d0, D0,
burn = 10, mcmc = 40, p = 0.25, tune = 1, verbose = FALSE)
mcmc <- 40
deltadraws <- output$deltadraws
betadraws <- output$betadraws
burn <- 0.25*mcmc
nsim <- burn + mcmc
postMeanbeta <- output$postMeanbeta
postMeandelta <- output$postMeandelta
deviance <- devianceOR1(y, xMat, betadraws, deltadraws,
postMeanbeta, postMeandelta, burn, mcmc, p = 0.25)

# DIC
#   1375.329
# pd
#   139.1751
# devpostmean
#   1096.979

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939

Spiegelhalter, D. J., Best, N. G., Carlin, B. P. and Linde, A. (2002).
“Bayesian Measures of Model Complexity and Fit.” Journal of the
Royal Statistical Society B, Part 4: 583-639. DOI: 10.1111/1467-9868.00353

Gelman, A., Carlin, J. B., Stern, H. S., and Rubin, D. B.
“Bayesian Data Analysis.” 2nd Edition, Chapman and Hall. DOI: 10.1002/sim.1856
}
\seealso{
decision criteria
}
