% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORII.R
\name{qrnegLogLike_or2}
\alias{qrnegLogLike_or2}
\title{Negative log-likelihood for ordinal quantile model with 3 outcomes}
\usage{
qrnegLogLike_or2(y, x, gammacp, beta, sigma, p)
}
\arguments{
\item{y}{observed ordinal outcomes, column vector of dimension \eqn{(n x 1)}.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones with or without column names.}

\item{gammacp}{row vector of cutpoints including -Inf and Inf.}

\item{beta}{column vector of coefficients of dimension \eqn{(k x 1)}.}

\item{sigma}{scale factor, a scalar.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns the negative log-likelihood value.
}
\description{
This function computes the negative of the log-likelihood for ordinal quantile
model with 3 outcomes.
}
\details{
Computes the negative of the log-likelihood for
ordinal quantile model with 3 outcomes where the error is assumed to follow
an asymmetric Laplace distribution.
}
\examples{
set.seed(101)
data("data25j3")
x <- data25j3$x
y <- data25j3$y
p <- 0.25
gammacp <- c(-Inf, 0, 3, Inf)
beta <- c(1.810504, 1.850332, 6.18116)
sigma <- 0.9684741
output <- qrnegLogLike_or2(y, x, gammacp, beta, sigma, p)

# output
#   902.4045

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939
}
\seealso{
likelihood maximization
}
