#' @name  data25j3
#' @title data25j3
#' Data with 500 observations for \eqn{p = 0.25} with 3 outcomes
#'
#' @details
#'
#' Generates 500 observations for the simulation study at the \eqn{25^{th}}
#' quantile. The specifications are \eqn{\beta = (-4, 6, 5)}, $X ~ Unif(0, 1)$, and
#' \eqn{\epsilon} ~ AL(\eqn{0, \sigma = 1, p = 0.25}).
#'
#' The errors are generated from an asymmetric Laplace distribution
#' by using its normal–exponential mixture formulation.
#'
#' The continuous value are classified into 3 categories using the
#' cut-points (0, 3).
#'
#' @docType data
#'
#' @usage data(data25j3)
#'
#' @return Returns a list with components
#' \itemize{
#' \item{\code{x}: }{a matrix of covariates.}
#' \item{\code{y}: }{a matrix of ordinal outcomes.}
#' }
#'
#' @references Kozumi, H. and Kobayashi, G. (2011). “Gibbs Sampling Methods for Bayesian Quantile Regression.”
#'  Journal of Statistical Computation and Simulation, 81(11), 1565–1578.
#'
#'
#' @keywords datasets
#'
#' @seealso \link[MASS]{mvrnorm}, Asymmetric Laplace Distribution
#'
NULL

#' @name  data50j3
#' @title data50j3
#' Data with 500 observations for \eqn{p = 0.5} with 3 outcomes
#'
#' @details
#' Generates 500 observations for the simulation study at the \eqn{50^{th}}
#' quantile. The specifications are \eqn{\beta = (-4, 6, 5)}, $X ~ Unif(0, 1)$, and
#' \eqn{\epsilon} ~ AL(\eqn{0, \sigma = 1, p = 0.50}).
#'
#' The errors are generated from an asymmetric Laplace distribution
#' by using its normal–exponential mixture formulation.
#'
#' The continuous value are classified into 3 categories using the
#' cut-points (0, 3).
#'
#' @docType data
#' @usage data(data50j3)
#'
#' @return Returns a list with components
#' \itemize{
#' \item{\code{x}: }{a matrix of covariates.}
#' \item{\code{y}: }{a matrix of ordinal outcomes.}
#' }
#'
#' @references Kozumi, H. and Kobayashi, G. (2011). “Gibbs Sampling Methods for Bayesian Quantile Regression.”
#'  Journal of Statistical Computation and Simulation, 81(11): 1565–1578.
#'
#'
#' @keywords datasets
#' @seealso \link[MASS]{mvrnorm}, Asymmetric Laplace Distribution
#'
NULL

#' @name  data75j3
#' @title data75j3
#' Data with 500 observations for \eqn{p = 0.75} with 3 outcomes
#'
#' @details
#' Generates 500 observations for the simulation study at the \eqn{75^{th}}
#' quantile. The specifications are \eqn{\beta = (-4, 6, 5)}, $X ~ Unif(0, 1)$,
#' and \eqn{\epsilon} ~ AL(\eqn{0, \sigma = 1, p = 0.75}).
#'
#' The errors are generated from an asymmetric Laplace distribution
#' by using its normal–exponential mixture formulation.
#'
#' The continuous value are classified into 3 categories using the
#' cut-points (0, 3).
#'
#' @docType data
#' @usage data(data75j3)
#'
#' @return Returns a list with components
#' \itemize{
#' \item{\code{x}: }{a matrix of covariates.}
#' \item{\code{y}: }{a matrix of ordinal outcomes.}
#' }
#'
#' @references Kozumi, H. and Kobayashi, G. (2011). “Gibbs Sampling Methods for Bayesian Quantile Regression.”
#'  Journal of Statistical Computation and Simulation, 81(11): 1565–1578.
#'
#' @keywords datasets
#' @seealso \link[MASS]{mvrnorm}, Asymmetric Laplace Distribution
#'
NULL

#' @name  data25j4
#' @title data25j4
#' Data with 500 observations for \eqn{p = 0.25} with 4 outcomes
#'
#' @details
#'
#' Generates 500 observations for the simulation study at the \eqn{25^{th}}
#' quantile. The specifications are \eqn{\beta = (-4, 5, 6)}, $X ~ Unif(0, 1)$,
#' and \eqn{\epsilon} ~ AL(\eqn{0, \sigma = 1, p = 0.25}).
#'
#' The errors are generated from an asymmetric Laplace distribution
#' by using its normal–exponential mixture formulation.
#'
#' The continuous value are classified into 4 categories using the
#' cut-points (0, 2, 4).
#'
#' @docType data
#' @usage data(data25j4)
#'
#' @return Returns a list with components
#' \itemize{
#' \item{\code{x}: }{a matrix of covariates.}
#' \item{\code{y}: }{a matrix of ordinal outcomes.}
#' }
#'
#' @references Kozumi, H. and Kobayashi, G. (2011). “Gibbs Sampling Methods for Bayesian Quantile Regression.”
#'  Journal of Statistical Computation and Simulation, 81(11): 1565–1578.
#'
#'
#' @keywords datasets
#' @seealso \link[MASS]{mvrnorm}, Asymmetric Laplace Distribution
#'
NULL

#' @name  data50j4
#' @title data50j4
#' Data with 500 observations for \eqn{p = 0.5} with 4 outcomes
#'
#' @details
#' Generates 500 observations for the simulation study at the \eqn{50^{th}}
#' quantile. The specifications are \eqn{\beta = (-4, 5, 6)}, $X ~ Unif(0, 1)$,
#' and \eqn{\epsilon} ~ AL(\eqn{0, \sigma = 1, p = 0.50}).
#'
#' The errors are generated from an asymmetric Laplace distribution
#' by using its normal–exponential mixture formulation.
#'
#' The continuous value are classified into 4 categories using the
#' cut-points (0, 2, 4).
#'
#'
#' @docType data
#' @usage data(data50j4)
#'
#' @return Returns a list with components
#' \itemize{
#' \item{\code{x}: }{a matrix of covariates.}
#' \item{\code{y}: }{a matrix of ordinal outcomes.}
#' }
#'
#' @references Kozumi, H. and Kobayashi, G. (2011). “Gibbs Sampling Methods for Bayesian Quantile Regression.”
#'  Journal of Statistical Computation and Simulation, 81(11): 1565–1578.
#'
#'
#' @keywords datasets
#' @seealso \link[MASS]{mvrnorm}, Asymmetric Laplace Distribution
#'
NULL

#' @name  data75j4
#' @title data75j4
#' Data with 500 observations for \eqn{p = 0.75} with 4 outcomes
#'
#' @details
#' Generates 500 observations for the simulation study at the \eqn{75^{th}}
#' quantile. The specifications are \eqn{\beta = (-4, 5, 6)}, $X ~ Unif(0, 1)$,
#' and \eqn{\epsilon} ~ AL(\eqn{0, \sigma = 1, p = 0.75}).
#'
#' The errors are generated from an asymmetric Laplace distribution
#' by using its normal–exponential mixture formulation.
#'
#' The continuous value are classified into 4 categories using the
#' cut-points (0, 2, 4).
#'
#' @docType data
#' @usage data(data75j4)
#'
#' @return Returns a list with components
#' \itemize{
#' \item{\code{x}: }{a matrix of covariates.}
#' \item{\code{y}: }{a matrix of ordinal outcomes.}
#' }
#'
#' @references Kozumi, H. and Kobayashi, G. (2011). “Gibbs Sampling Methods for Bayesian Quantile Regression.”
#'  Journal of Statistical Computation and Simulation, 81(11): 1565–1578.
#'
#'
#' @keywords datasets
#' @seealso \link[MASS]{mvrnorm}, Asymmetric Laplace Distribution
#'
NULL

#' @name  Educational_Attainment
#' @title Educational_Attainment
#' This data-set is based on National Longitudinal Study Youth (NLSY, 1979) survey data.
#' The data is used to analyze the study returns to schooling.
#'
#' @details
#'
#' This sub-sample from NLSY data-set here includes 3,923 individuals only. The sub-sample
#' is based on the cohorts aged 14-17 in 1979. The dependent variable i.e. the educational
#' degree, has four categories given as \emph{less than high school, high school degree, some
#' college or associate's degree} and \emph{college or graduate degree}.
#' The sample has 897 (22.87\%), 1392 (35.48\%), 876 (22.33\%) and 758 (19.32\%) observations in
#' respectively in each category.
#'
#' @docType data
#'
#' @usage data(Educational_Attainment)
#'
#' @return Returns data with components
#' \itemize{
#' \item{\code{mother_work}: }{Indicator for working female at age of 14.}
#' \item{\code{urban}: }{Indicator for the youth living in urban are at age of 14.}
#' \item{\code{south}: }{Indicator for the youth living in South at age of 14.}
#' \item{\code{father_educ}: }{Individual's father education.}
#' \item{\code{mother_educ}: }{Individual's mother education.}
#' \item{\code{fam_income}: }{Family income of the household.}
#' \item{\code{female}: }{Indicator for Individuals gender.}
#' \item{\code{black}: }{Race of the individual is white.}
#' \item{\code{age_cohort_2}: }{Indicator for age of 15.}
#' \item{\code{age_cohort_3}: }{Indicator for age of 16.}
#' \item{\code{age_cohort_4}: }{Indicator for age of 17.}
#' \item{\code{dep_edu_level}: }{a matrix of ordinal outcomes.}
#' }
#'
#' @references Rahman, M. A. (2016). “Bayesian
#' Quantile Regression for Ordinal Models.”
#' Bayesian Analysis, 11(1): 1-24.
#'
#' Jeliazkov, I., Graves, J., and Kutzbach, M. (2008). “Fitting and Comparison of Models
#' for Multivariate Ordinal Outcomes.” Advances in Econometrics: Bayesian Econometrics, 23: 115–156.
#'
#' @keywords datasets
#'
#' @seealso \href{https://www.bls.gov/nls/}{NLSY}, \href{https://www.bls.gov/nls/nlsy97.htm}{Survey Process}.
#'
NULL

#' @name  Policy_Opinion
#' @title Policy_Opinion
#' The data-set is based on the survey conducted by American National Election Studies (ANES) in 2010-2012.
#' This data talks about the public opinion on the pro-growth tax policy, considered to raise the federal
#' income taxes for couples (individuals) earning more than $250,000 ($200,000) per year.
#'
#' @details
#'
#' The ANES data-set here provides 1,164 observations. The responses from individuals were
#' recorded as either \emph{oppose, neither favor nor oppose} or \emph{favor} the tax increase.
#' The sample has 263 (22.59\%), 261 (22.42\%) and 640 (54.98\%) observations in respective categories.
#'
#' @docType data
#'
#' @usage data(Policy_Opinion)
#'
#' @return Returns data with components
#' \itemize{
#' \item{\code{Intercept}: }{A column of ones.}
#' \item{\code{AgeCat}: }{Indicator for Age Category.}
#' \item{\code{IncomeCat}: }{Indicator for household income > $75,000.}
#' \item{\code{Bachelors}: }{Individual's highest degree in Bachelors.}
#' \item{\code{Post.Bachelors}: }{Highest degree in Masters, Professional or Doctorate.}
#' \item{\code{numComputers}: }{Individual or household owns a computer.}
#' \item{\code{CellPhone}: }{Individual or household owns a cell phone.}
#' \item{\code{White}: }{Race of the individual is white.}
#' \item{\code{y}: }{a matrix of ordinal outcomes.}
#' }
#'
#' @references Rahman, M. A. (2016). “Bayesian
#' Quantile Regression for Ordinal Models.”
#' Bayesian Analysis, 11(1): 1-24.
#'
#' Jeliazkov, I., Graves, J., and Kutzbach, M. (2008). “Fitting and Comparison of Models
#' for Multivariate Ordinal Outcomes.” Advances in Econometrics: Bayesian Econometrics, 23: 115–156.
#'
#' @keywords datasets
#'
#' @seealso \href{https://electionstudies.org/data-center/}{ANES},  \href{https://georgewbush-whitehouse.archives.gov/cea/progrowth.html}{Tax Policy}
#'
NULL

