% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxr_upload_download.R
\name{box_dl}
\alias{box_dl}
\alias{box_ul}
\title{Download/upload files from/to Box}
\usage{
box_dl(file_id, local_dir = getwd(), overwrite = FALSE,
  file_name = NULL, version_id = NULL, version_no = NULL,
  pb = options()$boxr.progress, filename)

box_ul(dir_id = box_getwd(), file, pb = options()$boxr.progress,
  description = NULL)
}
\arguments{
\item{file_id}{\code{numeric} or \code{character}, file ID at Box.}

\item{local_dir}{\code{character}, path to local directory.}

\item{overwrite}{\code{logical}, indicates that newer files at origin will
overwrite older files at destination.}

\item{file_name}{\code{character}, if supplied, an alternate filename
for the local version of the Box file.}

\item{version_id}{\code{character} or \code{numeric}, the \code{version_id} of the file.}

\item{version_no}{\code{numeric}, version of the file you'd like to download
(starting at 1).}

\item{pb}{\code{logical}, indicates to show progress bar
(via \code{\link[=setTxtProgressBar]{setTxtProgressBar()}}).}

\item{filename}{\code{character}, \strong{deprecated}: use \code{file_name} instead.}

\item{dir_id}{\code{numeric} or \code{character}, folder ID at Box.}

\item{file}{\code{character}, local path to the file.}

\item{description}{\code{character}, description caption for the file.}
}
\value{
\describe{
\item{\code{box_dl()}}{\code{character}, local path to the downloaded file.}
\item{\code{box_ul()}}{Object with S3 class \code{\link[=boxr_S3_classes]{boxr_file_reference}}.}
}
}
\description{
\describe{
\item{\code{box_dl()}}{download a file from Box to a local directory}
\item{\code{box_ul()}}{upload a local file to a Box folder}
}
}
\section{Versions}{


\code{box_dl()} can accept one of two parameters to specify file versions:
\strong{\code{version_id}} or \strong{\code{version_no}}.

The box.com API refers to file versions using 11 digit ids (which can be
accessed via \code{\link[=box_previous_versions]{box_previous_versions()}}) - you can specify these
using the \code{version_id} parameter.

However, this isn't terribly intuitive. As a result, \code{box_dl()}
provides the \code{version_no} parameter, which accepts a whole number,
and corresponds to the versions that you'll see via the web UI. For
example to download the version marked 'V2' on box.com, specify
\code{version_no = 2}. This works by making an internal call to
\code{\link[=box_previous_versions]{box_previous_versions()}} to retrieve the \code{version_id},
which makes it slightly slower.
}

\seealso{
\itemize{
\item \code{\link[=box_fetch]{box_fetch()}} and \code{\link[=box_push]{box_push()}} for
directory-wide equivalents.
\item \code{\link[=box_delete_file]{box_delete_file()}} for removing
uploaded files.
\item \code{\link[=box_source]{box_source()}} for R code.
\item \code{\link[=box_save]{box_save()}}/\code{\link[=box_load]{box_load()}} for remote R objects.
}
}
