% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMSC-plot.R
\name{plot.pairwise.BMSC}
\alias{plot.pairwise.BMSC}
\title{Plot estimates from a \code{pairwise.BMSC} object.}
\usage{
\method{plot}{pairwise.BMSC}(x, type = "interval", CI = 0.95, ...)
}
\arguments{
\item{x}{An object of class \link{pairwise.BMSC}.}

\item{type}{a parameter to select the typology of graph
\describe{
        \item{interval}{the estimates will be represented by means of pointrange, with median and the boundaries of the credible interval}
        \item{area}{a density plot}
        \item{hist}{a density histogram}
}}

\item{CI}{the dimension of the Credible Interval (or Equally Tailed Interval). Default 0.95.}

\item{...}{other arguments are ignored.}
}
\value{
a list of two ggplot2 objects
}
\description{
Plot estimates from a \code{pairwise.BMSC} object.
}
\examples{
 \donttest{

 data(BSE)

 # Normal regression of data coming from a body representation paradigm
 # with a control sample of 12 participants and one patient with
 # unilateral brachial plexus lesion
 mdl <- BMSC(formula = RT ~ Body.District * Congruency * Side +
             (Body.District + Congruency + Side | ID),
             data_ctrl = data.ctrl,
             data_pt = data.pt,
             cores = 4)

 # generate a summary of the results
 summary(mdl)

 # posterior predictive p-value checking
 pp_check(mdl, limited = FALSE)

 # plot of the results
 plot(mdl)

 # compute pairwise contrasts
 ph <- pairwise(mdl , contrast = "Body.District1:Side1")

 ph

 # plot pairwise comparisons

 plot(ph)

 plot(ph , type = "area")

 # customization of pairiwse comparisons plot

 plot(ph)[[1]]+theme_bw(base_size = 18)

 plot(ph , type = "area")[[1]]+theme_bw(base_size = 18)+
   theme(strip.text.y = element_text( angle = 0))
}

}
