% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.frv}
\alias{plot.frv}
\title{Plot for graphical selection of the constant}
\usage{
\method{plot}{frv}(x, ..., pkg = "base")
}
\arguments{
\item{x}{An object returned from the function
\link[=select_frv]{select_frv}}

\item{...}{Other parameters}

\item{pkg}{Graphical package to be used for plotting. Current values are
"base".}
}
\value{
No return value.
}
\description{
Plots the output of a frv object. It shows how the number of change-points
estimated by the given model vary with the regularization constant lambda.
Graphical inspection can be used to choose a proper value for the constant.
The suggestion is to pick a value in which the curve starts to "flat-out"
}
\examples{
td = rcpd(nrow = 10, ncol = 10)
frv = select_frv(td$data_matrix)
plot(frv)
}
