% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_orders.R
\name{cancel_all_orders}
\alias{cancel_all_orders}
\title{Cancel all orders}
\usage{
cancel_all_orders(symbol = NULL, filter = NULL, text = NULL)
}
\arguments{
\item{symbol}{string. Optional symbol. If provided, only cancels orders for that symbol.}

\item{filter}{string. Optional filter for cancellation. Use to only cancel some orders,
e.g. '{"side": "Buy"}'.}

\item{text}{string. Optional cancellation annotation. e.g. 'Spread Exceeded'.}
}
\value{
Returns a \code{data.frame} with information about the orders that were cancelled.
See \url{https://www.bitmex.com/api/explorer/#!/Order/Order_cancelAll} for more information.
}
\description{
Cancel all orders that have been placed for a specific symbol,
or use a filter to select specific orders.
}
\examples{
\dontrun{
# cancel all "Buy" orders
cancel_all_orders(filter = '{"side": "Buy"}')
}

}
