% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{calc_factor_conc}
\alias{calc_factor_conc}
\title{Get a factor to convert concentrations.}
\usage{
calc_factor_conc(from, to, molar_mass = 0, density_solute = 0,
  density_solution = 0)
}
\arguments{
\item{from}{A string containing the units of concentration A.}

\item{to}{A string containing the units of concentration B.}

\item{molar_mass}{The molar mass of the solute (g / mol).}

\item{density_solute}{The density of the solute (g / l).}

\item{density_solution}{The density of the solution (g / l), not the solvent!}
}
\value{
The factor to convert A into B.
}
\description{
Calculate a factor to convert concentration "A" into concentration "B".
}
\details{
The following concentrations can be converted:

mass / volume:
".g / .l", ".g / .m^3", "\% w / v"

molar / volume:
".M", ".mol / .l",  ".mol / .m^3"

volume / volume:
".l/.l", ".l / m^3", ".m^3/.m^3", ".m^3 / .l", "\% v / v", "v / v"

mass / mass:
".g / .g", "w / w", "\% w / w"

Where "." symbolises a metric prefix (see \code{\link[=calc_factor_prefix]{calc_factor_prefix()}}) :

For g, l, mol and M: m (milli), µ (micro), n (nano), p (pico) and f (femto).

For g you might use k (kilo) as well.

For m^3 (cubic metres): d (deci), c (centi) and m (milli)

Note: \% w / v is (incorrectly) taken as a short hand for 0.1 g / l.
}
\examples{
calc_factor_conc(from = "ng / ml", to = "g / l")
calc_factor_conc(from = "ng / ml", to = "mmol / l", molar_mass = 150000)

}
\seealso{
Other conversion functions: \code{\link{calc_factor_prefix}},
  \code{\link{convert_conc}}, \code{\link{convert_prefix}}
}
