% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binman_utils.R
\name{rm_version}
\alias{rm_version}
\title{Remove application version}
\usage{
rm_version(appname, platform, version = c("ALL"))
}
\arguments{
\item{appname}{A character string giving the name of the application}

\item{platform}{A character string indicating the platform.}

\item{version}{A character vector of versions to remove. Defaults to
"ALL"}
}
\value{
Returns a logical vector indicating whether the removal of
    version was successful. Return is invisible.
}
\description{
Remove application version for a given platform
}
\examples{
\dontrun{
appdir <- app_dir(appname, FALSE)
platforms <- LETTERS[1:4]
versions <- LETTERS[5:7]
mkdirs <- file.path(appdir, outer(platforms, versions, file.path))
chk <- vapply(mkdirs, dir.create, logical(1), recursive = TRUE)
appver <- list_versions(appname)
rm_version(appname, platforms[2], versions[1:2])
unlink(appdir, recursive = TRUE)
}
}

