% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_yaml.R
\name{process_yaml}
\alias{process_yaml}
\title{Process a yaml file}
\usage{
process_yaml(ymlfile)
}
\arguments{
\item{ymlfile}{A file in a YAML format defining the pre-download/
download and post download functions together with their arguments.}
}
\value{
A list of files processed (downloaded and post processed)
}
\description{
Process a yaml file. The file defines the pre-download function,
    the download function and the post download function.
}
\examples{
\dontrun{
ymlfile <- system.file("exdata", "sampleapp.yml", package="binman")
trdata <- system.file("testdata", "test_dlres.Rdata", package="binman")
load(trdata)
testthat::with_mock(
  `httr::GET` = function(...){
    test_llres
  },
  `base::dir.create` = function(...){TRUE},
  `utils::unzip` = function(zipfile, ...){zipfile},
  procyml <- process_yaml(ymlfile)
)
procyml
}
}

