% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigfloat.R
\name{bigfloat}
\alias{bigfloat}
\alias{as_bigfloat}
\alias{is_bigfloat}
\title{High-Precision Numeric Vectors}
\usage{
bigfloat(x = character())

as_bigfloat(x)

is_bigfloat(x)
}
\arguments{
\item{x}{Object to be coerced or tested.}
}
\value{
An S3 vector of class \code{bignum_bigfloat}.
}
\description{
\code{bigfloat()} and \code{as_bigfloat()} construct a vector designed to store numbers
with 50 decimal digits of precision.

\code{is_bigfloat()} checks if an object is of class \code{bignum_bigfloat}.
}
\examples{
bigfloat(1) / 3
}
\seealso{
\code{\link{NA_bigfloat_}} to represent missing values.

\code{\link[=format.bignum_bigfloat]{format()}} for pretty printing.

\code{vignette("operations")} for supported operations.
}
