## ----set-options,echo=FALSE---------------------------------------------------
options(width=80)
knitr::opts_chunk$set(fig.align = 'center', out.width = '70%')

## ---- warning = FALSE---------------------------------------------------------
library(bigMap)

## ---- eval = TRUE, echo = FALSE, results = 'hide'-----------------------------
bdm.local('cluster-ceab.ceab.csic.es')
bdm.mybdm('~/myPath/')

## -----------------------------------------------------------------------------
bdm.example()

## ---- echo = FALSE------------------------------------------------------------
dMap.copy <- exMap$dMap
exMap$dMap <- NULL

## -----------------------------------------------------------------------------
str(exMap)

## -----------------------------------------------------------------------------
X <- exMap$data     # let's assume this is our raw data matrix
dim(X)

## -----------------------------------------------------------------------------
myMap <- bdm.init('myDataset', X)
str(myMap)

## ---- eval = FALSE------------------------------------------------------------
#  myDistMap <- bdm.init('myDataset', X, is.distance = TRUE)     # don't run

## -----------------------------------------------------------------------------
L <- exMap$lbls     # assume this is our vector of labels

## -----------------------------------------------------------------------------
myMap <- bdm.init('myDataset', X, labels = L)
str(myMap)

## ---- echo = FALSE------------------------------------------------------------
myMap$Xdata <- exMap$Xdata
myMap$Xbeta <- exMap$Xbeta
myMap$ptsne  <- exMap$ptsne

## ---- eval = FALSE------------------------------------------------------------
#  myMap <- bdm.ptsne(myMap, threads = 4, layers = 2, rounds = 2, ppx = 25)

## -----------------------------------------------------------------------------
str(myMap$ptsne)

## ---- fig.height = 4.0--------------------------------------------------------
bdm.ptsne.plot(myMap)

## ---- echo = FALSE------------------------------------------------------------
myMap$pakde  <- exMap$pakde
myMap$pakde[[2]] <- NULL

## ---- eval = FALSE------------------------------------------------------------
#  myMap <- bdm.pakde(myMap, threads = 4, ppx = 50, g.exp = 2)

## -----------------------------------------------------------------------------
str(myMap$pakde)

## ---- fig.height = 4.0--------------------------------------------------------
bdm.pakde.plot(myMap)

## ---- echo = FALSE------------------------------------------------------------
myMap$wtt  <- exMap$wtt
myMap$wtt[[2]] <- NULL

## ---- eval = FALSE------------------------------------------------------------
#  myMap <- bdm.wtt(myMap)

## -----------------------------------------------------------------------------
str(myMap$wtt)

## -----------------------------------------------------------------------------
bdm.wtt.plot(myMap)

## -----------------------------------------------------------------------------
myDataLabels <- bdm.labels(myMap)

## ---- fig.height = 3.8--------------------------------------------------------
bdm.cost(myMap)

## ---- fig.height = 3.5--------------------------------------------------------
bdm.ptsne.plot(myMap, ptsne.cex = 0.6, class.pltt = rainbow(16), layer = 2)

## ---- fig.height = 7.0--------------------------------------------------------
bdm.qMap(myMap, data = myMap$data[, 1:4], subset = which(myMap$lbls %in% 1:8))

## -----------------------------------------------------------------------------
# assume these are our class covariates
myclasses <- c('A', 'B', 'C', 'D', 'E')[(myMap$lbls %/% 4) +1]

## ---- echo = FALSE------------------------------------------------------------
myMap$dMap <- dMap.copy

## ---- eval = FALSE------------------------------------------------------------
#  myMap <- bdm.dMap(myMap, threads = 4, data = myclasses)

## ---- fig.height = 6.0--------------------------------------------------------
bdm.dMap.plot(myMap, classes = c('A', 'B', 'E'))

## ---- fig.height = 5.5--------------------------------------------------------
bdm.boxp(myMap)

## ---- results = 'hide'--------------------------------------------------------
myMap <- bdm.optk.s2nr(myMap, plot.optk = F, ret.optk = T)

## ---- fig.height = 5.0--------------------------------------------------------
bdm.optk.plot(myMap)

## -----------------------------------------------------------------------------
myMap <- bdm.merge.s2nr(myMap, k = 6, plot.merge = F, ret.merge = T)

## ---- fig.height = 6.0--------------------------------------------------------
bdm.wtt.plot(myMap)

## -----------------------------------------------------------------------------
bdm.mybdm('~/myPath/')

## -----------------------------------------------------------------------------
bdm.fName(myMap)

## ---- eval = FALSE------------------------------------------------------------
#  bdm.save(myMap)

## -----------------------------------------------------------------------------
bdm.local('xxx.xxx.xxx.xxx')

## ---- eval = FALSE------------------------------------------------------------
#  bdm.scp(myMap)

