% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaNB-methods-beta-nb.R
\name{coef.betanb}
\alias{coef.betanb}
\title{Estimated Parameter Method for an Object of Class
\code{betanb}}
\usage{
\method{coef}{betanb}(object, ...)
}
\arguments{
\item{object}{Object of Class \code{betanb},
that is,
the output of the
\code{BetaNB()},
\code{RSqNB()},
\code{SCorNB()},
\code{DeltaRSqNB()}, or
\code{PCorNB()}
functions.}

\item{...}{additional arguments.}
}
\value{
Returns a vector of estimated parameters.
}
\description{
Estimated Parameter Method for an Object of Class
\code{betanb}
}
\examples{
# Fit the regression model
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
# Generate bootstrap covariance matrices
# (use a large R, for example, R = 5000 for actual research)
nb <- NB(object, R = 50)
# Generate confidence intervals for standardized regression slopes
std <- BetaNB(nb)
# Method ---------------------------------------------------------
coef(std)
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
