% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_plot.R
\name{line_plot}
\alias{line_plot}
\title{Generate quick line plot}
\usage{
line_plot(data_type = c("unit", "unit.locality", "variable",
  "variable.locality"), unitId = NULL, varId = NULL, year = NULL,
  aggregateId = NULL, lang = NULL, unitParentId = NULL,
  unitLevel = NULL, ...)
}
\arguments{
\item{data_type}{A type of data used for generating plot, "unit"(default), "unit.locality","variable","variable.locality"}

\item{unitId}{A 12 character NUTS unit id or locality  12 character id with 7 characters locality individual id, separated by dash.}

\item{varId}{A vector of variable Id's (data_type equal "unit" or "unit.locality) 
or single variable (data_type equal "variable" or "variable.locality"). Use \code{\link{search_variables}} or
\code{\link{get_variables}} to find variable id code.}

\item{year}{A vector of years. If \code{NULL} (default) returns data for all available years.}

\item{aggregateId}{An aggregate id. Use \code{\link{get_aggregates}} for more info.}

\item{lang}{A language of returned data, "pl" (default), "en"}

\item{unitParentId}{A 12 character NUTS id code of interested unit. (Used only with data_type equal "variable" or "variable.locality")
Use \code{\link{search_units}} or
\code{\link{get_units}} to find unit id code.}

\item{unitLevel}{A number from 0 to 6, filters the returned unit by its level. (Used only with data_type equal "variable")
If \code{NULL} (default) no level filters apply. Use \code{\link{get_levels}} to find more info.}

\item{...}{Other arguments passed on to \code{\link[httr]{GET}}. For example
a proxy parameters, see details.}
}
\value{
A ggplot2 plot.
}
\description{
Generate line plot for one unit/multiple variables or variable/multiple units
}
\details{
Generate quickly `ggplot2` plot, using BDL data.
  
  Plot multiple variable values for one unit or one variable value for multiple units.
  
  
  To use a proxy to connect, a \code{\link[httr]{use_proxy}} can be
  passed to \code{\link[httr]{GET}}. For example
  \code{get_request(id, filters,
  config = httr::use_proxy(url, port, username, password))}.
}
\examples{
\donttest{
  line_plot(data_type = "unit", unitId = "000000000000", varId = c("415","420"))
}
}
