% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate-map.R
\name{generate_map}
\alias{generate_map}
\title{Generate a map of trends by strata.}
\usage{
generate_map(trend = NULL, select = FALSE, stratify_by = NULL,
  slope = FALSE, species = "")
}
\arguments{
\item{trend}{Dataframe of strata trends produced by
\code{generate_strata_trends} or \code{generate_regional_trends(..., regions = "stratum")}}

\item{select}{logical flag to indicate if the stratum data need to be selected out of an trends object that includes continental, national, or other region-types. Default is FALSE}

\item{stratify_by}{How were the data stratified?}

\item{slope}{Logical, if TRUE, maps values of the alternative trend metric if slope = TRUE was used in \code{generate_strata_trends}, the slope of a log-linear regression through the annual indices. Default FALSE.}

\item{species}{Text, optional species name to add plot title. if left blank "" no title is added}
}
\value{
spplot object
}
\description{
\code{generate_map} allows you to generate a colour-coded map of species trends
  for each strata. Given trends generated by \code{generate_strata_trends}, this
  function will shade in each stratum based on the percent
  change in that stratum.
}
\examples{
# Toy example with Pacific Wren sample data
# First, stratify the sample data
strat_data <- stratify(by = "bbs_cws", sample_data = TRUE)

# Prepare the stratified data for use in a JAGS model.
jags_data <- prepare_jags_data(strat_data = strat_data,
                               species_to_run = "Pacific Wren",
                               model = "firstdiff",
                               min_year = 2009,
                               max_year = 2018)

# Now run a JAGS model.
jags_mod <- run_model(jags_data = jags_data,
                      n_adapt = 0,
                      n_burnin = 0,
                      n_iter = 10,
                      n_thin = 1)

# Generate the continental and stratum indices
indices <- generate_indices(jags_mod = jags_mod,
                            jags_data = jags_data)

# Now, generate the trends
trends <- generate_trends(indices = indices)

# Generate the map. Set select = TRUE because we are passing a
#    dataframe of trends of more than just the stratum regions
map <- generate_map(trend = trends,
                    stratify_by = "bbs_cws",
                    select = TRUE,
                    species = "Pacific Wren")
}
