% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumplot.R
\name{cumplot}
\alias{cumplot}
\title{Plot the cumulative median, mean, and 95\% high posterior density region.}
\usage{
cumplot(x, ylab = NULL, burn = 0, thin = 1, hpd_level = 0.95)
}
\arguments{
\item{x}{An vector of MCMC draws.}

\item{ylab}{An optional y-axis label.}

\item{burn}{Integer specifying the number of initial iterations to be
discarded.}

\item{thin}{Integer specifying the thinning factor to be used on
the MCMC steps.}

\item{hpd_level}{Floating point specifying the desired HPD level.}
}
\value{
A ggplot showing the cumulative mean, median and HPD.
}
\description{
Plot the cumulative median, mean, and 95\% high posterior density region.
}
\examples{
x <- rnorm(1000)
cumplot(x)
}
