#' babette: A package for Bayesian phylogenetics.
#'
#' 'babette' provides for an alternative workflow of using
#' the popular phylogenetics tool 'BEAST2', including
#' it peripheral tools. From an alignment and
#' inference model, a posterior of jointly estimated
#' phylogenies and parameter estimates is generated.
#'
#' @examples
#' if (is_beast2_installed()) {
#'
#'   inference_model <- create_test_inference_model()
#'   beast2_options <- create_beast2_options()
#'
#'   bbt_run_from_model(
#'     fasta_filename = get_babette_path("anthus_aco.fas"),
#'     inference_model = inference_model,
#'     beast2_options = beast2_options
#'   )
#'
#'   # Clean up temporary files created by babette
#'   bbt_delete_temp_files(
#'     inference_model = inference_model,
#'     beast2_options = beast2_options
#'   )
#' }
#' @seealso
#' Use \link{bbt_self_test} to do verify \link{babette} is installed
#' correctly.\cr
#'
#' These are packages associated with 'babette':
#' \itemize{
#'   \item{
#'     '\link[beautier]{beautier}' creates 'BEAST2' input files.
#'   }
#'   \item{
#'     '\link[beastier]{beastier}' runs 'BEAST2'.
#'   }
#'   \item{
#'     '\link[mauricer]{mauricer}' does 'BEAST2' package management.
#'   }
#'   \item{
#'     '\link[tracerer]{tracerer}' parses 'BEAST2' output files.
#'   }
#' }
#' @docType package
#' @author Richèl J.C. Bilderbeek
#' @name babette
#' @import beautier tracerer beastier mauricer
NULL
