% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available.R
\name{suggest}
\alias{suggest}
\title{Suggest a package name based on a development package title or description}
\usage{
suggest(path = ".", field = c("Title", "Description"), text = NULL)
}
\arguments{
\item{path}{Path to a existing package to extract the title from.}

\item{field}{one of "Title" or "Description"}

\item{text}{text string to search.}
}
\description{
If the package you are using already has a title, simply pass the path to
the package root in \code{path}. Otherwise use \code{title} to specify a potential
title.
}
\examples{
\dontrun{
# Default will use the title from the current path.
suggest()

# Can also suggest based on the description
suggest(field = "Description")
}

# Or by explicitly using the text argument
suggest(text =
  "A Package for Displaying Visual Scenes as They May Appear to an Animal with Lower Acuity")
}
