% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_best_subset.R
\name{run_best_subset_mc}
\alias{run_best_subset_mc}
\title{Best subset multicore tuning.}
\usage{
run_best_subset_mc(
  y,
  L1.x,
  L2.x,
  L2.unit,
  L2.reg,
  loss.unit,
  loss.fun,
  data,
  cores,
  models,
  verbose
)
}
\arguments{
\item{y}{Outcome variable. A character scalar containing the column name of
the outcome variable in \code{survey}.}

\item{L1.x}{Individual-level covariates. A character vector containing the
column names of the individual-level variables in \code{survey} and
\code{census} used to predict outcome \code{y}. Note that geographic unit
is specified in argument \code{L2.unit}.}

\item{L2.x}{Context-level covariates. A character vector containing the
column names of the context-level variables in \code{survey} and
\code{census} used to predict outcome \code{y}.}

\item{L2.unit}{Geographic unit. A character scalar containing the column
name of the geographic unit in \code{survey} and \code{census} at which
outcomes should be aggregated.}

\item{L2.reg}{Geographic region. A character scalar containing the column
name of the geographic region in \code{survey} and \code{census} by which
geographic units are grouped (\code{L2.unit} must be nested within
\code{L2.reg}). Default is \code{NULL}.}

\item{loss.unit}{Loss function unit. A character-valued scalar indicating
whether performance loss should be evaluated at the level of individual
respondents (\code{individuals}) or geographic units (\code{L2 units}).
Default is \code{individuals}.}

\item{loss.fun}{Loss function. A character-valued scalar indicating whether
prediction loss should be measured by the mean squared error (\code{MSE})
or the mean absolute error (\code{MAE}). Default is \code{MSE}.}

\item{data}{Data for cross-validation. A \code{list} of \eqn{k}
\code{data.frames}, one for each fold to be used in \eqn{k}-fold
cross-validation.}

\item{cores}{The number of cores to be used. An integer indicating the number
of processor cores used for parallel computing. Default is 1.}

\item{models}{The models to perform best subset selection on. A list of model
formulas.}

\item{verbose}{Verbose output. A logical argument indicating whether or not
verbose output should be printed. Default is \code{TRUE}.}
}
\value{
The cross-validation errors for all models. A list.
}
\description{
\code{run_best_subset_mc} is called from within \code{run_best_subset}. It
tunes using multiple cores.
}
\examples{
\dontrun{
# not yet
}
}
