% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tasks.R
\name{tsk_output}
\alias{tsk_output}
\alias{tsk_output_xpose4}
\title{Task output}
\usage{
tsk_output(filename = "sdtab", variables)

tsk_output_xpose4()
}
\arguments{
\item{filename}{The filename for the output file}

\item{variables}{The model variables that be included in the output}
}
\value{
A building block of type 'output_task'
}
\description{
These functions define output tasks that include the selected variables in the output of the generated model.
}
\details{
\subsection{Tasks}{

Tasks are building blocks that allow to specify what a model should
“do”. Like other model building blocks, they can be combined using
the \code{+} operator. However, they should not be added to a model but
rather provided via the \verb{tasks=} argument to the render function, e.g.,\if{html}{\out{<div class="r">}}\preformatted{render(m, tasks = tsk_estimation() +
   tsk_output_xpose4())
}\if{html}{\out{</div>}}
}

\subsection{Output tasks}{

For NONMEM, an output task defines the \verb{$TABLE} records by specifying the \verb{filename=} as well as the \verb{variables=} to include.

The variables can be specified by providing a character vector of variable names (e.g., \code{variables =  c('cl','v')}) or by
using a set of variable selection helpers (e.g., \code{variables = vars_prms()}). The latter is shorter if many variables are to
be selected and allows the specification of tasks independent from the model. The details of the variable selection language
can be found on the help pages for \link{model-variable-selection}.
}

\subsection{xpose4 output task}{

The \code{tsk_output_xpose4()} function includes \verb{$TABLE} records that follow the output conventions of the model diagnostic package xpose4.
It is a shortcut for the following two output tasks:\preformatted{ xpose4_output <- tsk_output("sdtab", variables = any_of(c("id","time")) | vars_nm_std()) +
  tsk_output("patab", variables = vars_prms() | vars_eta())
}
}
}
\examples{
m <- model() +
  input_variable("dose") +
  prm_log_normal("emax", median = 10, var_log = 0.09) +
  prm_log_normal("ed50", median = 50, var_log = 0.09) +
  algebraic(effect~emax*dose/(ed50 + dose)) +
  obs_proportional(~effect, var_prop = 1)
# output model parameters to file 'prms'
render(m, tasks = tsk_output("prms", variables = vars_prms()))
# output variables required by xpose4
render(m, tasks = tsk_output_xpose4())
}
\seealso{
Other tasks: 
\code{\link{tsk_estimation}()}
}
\concept{tasks}
