% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_component.R
\name{pk_distribution_3cmp}
\alias{pk_distribution_3cmp}
\title{PK distribution 3 compartments}
\usage{
pk_distribution_3cmp(
  prm_vc = prm_log_normal("vc", median = 100, var_log = 0.1),
  prm_vp1 = prm_log_normal("vp1", median = 5, var_log = 0.1),
  prm_vp2 = prm_log_normal("vp2", median = 5, var_log = 0.1),
  prm_q1 = prm_log_normal("q1", median = 25, var_log = 0.1),
  prm_q2 = prm_log_normal("q2", median = 25, var_log = 0.1)
)
}
\arguments{
\item{prm_vc}{Parameter model for the central volume of distribution}

\item{prm_vp1}{Parameter model for the volume of the first peripheral compartment}

\item{prm_vp2}{Parameter model for the volume of the second peripheral compartment}

\item{prm_q1}{Parameter model for the inter-compartmental clearance between central and first peripheral compartment}

\item{prm_q2}{Parameter model for the inter-compartmental clearance between central and second peripheral compartment}
}
\value{
A building block of type 'pk_component'
}
\description{
This building block declares a three compartment distribution component for a pharmacokinetic model.
}
\details{
\subsection{PK components}{

PK components can be added to a \link{pk_model} and exist in
three different types: absorption, distribution, and elimination. The
absorption component is optional, distribution and elimination are not
and need to be added for the PK model to be valid.

A PK model can only have one component of each type and adding a
component with an already existing type will replace the previous
definition. For example, the distribution component will be a two
compartment model in the following snippet:\preformatted{pkm <- pk_model() +
  pk_absorption_fo() +
  pk_distribution_1cmp() +
  pk_distribution_2cmp() +
  pk_elimination_linear() +
  obs_additive(conc~C["central"]) 
pkm
}
}

\subsection{Parameter models}{

All PK component functions allow the specification of the parameter
model via their arguments. Arguments that refer to a parameter start
with the prefix \code{prm_}. The default parameter model can be deduced from
the default arguments in the usage section of the help entry. The
parameter name, specified via the \verb{name=} argument of the parameter
model building block allows the renaming of the model parameters.

For example, the parameter \verb{prm_vc=} refers to the central volumen of
distribution parameter in the one compartment distribution PK component
and the default parameter model is a log-normal distribution. The
follwing code block specifies a normal distribution parameter model and
names the parameter \code{v}:\preformatted{pk_distribution_1cmp(
    prm_vc = prm_normal("v", mean = 50, var = 25)
)
}
}
}
\seealso{
\code{\link[=pk_model]{pk_model()}} for the creation of PK models

Other distribution components: 
\code{\link{pk_distribution_1cmp}()},
\code{\link{pk_distribution_2cmp}()}
}
\concept{distribution components}
