% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magrittr_extensions.R
\name{iff}
\alias{iff}
\alias{iffn}
\alias{iffelse}
\title{Apply a function if and only if test is TRUE}
\usage{
iff(obj, test, fun, ...)

iffn(obj, test, fun, ...)

iffelse(obj, test, true_fun, false_fun, ...)
}
\arguments{
\item{obj}{object to apply test and fun to}

\item{test}{logical or function to apply to test}

\item{fun}{function to apply}

\item{...}{passed on to test}

\item{true_fun}{function to apply when test is true}

\item{false_fun}{function to apply when test is false}
}
\description{
otherwise return input value unchanged
}
\details{
iffn is ... if and only if test is FALSE
}
\examples{
require(magrittr)
x <- sample(c(1,2,NA), 1)
x <- x \%>\%
  iff(is.na, const(0))
y <- x\%>\%
  iff(x <= 0, function(x) { x - 2 })

x <- sample(c(1,2,NA), 1)
x \%>\%
  iffn(is.na, exp)

}
