% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{methods}
\name{[[,argoFloats-method}
\alias{[[,argoFloats-method}
\title{Look up a Value Within an argoFloats Object}
\usage{
\S4method{[[}{argoFloats}(x, i, j, ...)
}
\arguments{
\item{x}{an \code{\linkS4class{argoFloats}} object.}

\item{i}{a character value that specifies the item to be looked up;
see \dQuote{Details}.}

\item{j}{supplemental index value, used for some \code{x} types
and \code{i} values; see \dQuote{Details}.}

\item{...}{ignored.}
}
\value{
the indicated item, or NULL if it is neither stored within the first argument
nor computable from its contents.
}
\description{
This function provides an easy way to look up values within an \code{\linkS4class{argoFloats}}
object, without the need to know the exact structure of the data. The action
taken by \code{[[} depends on the \code{type} element in the \code{metadata} slot of
the object (which is set by the function that created the object), on the
value of \code{i} and, in some cases, on the value of \code{j}; see \dQuote{Details}.
}
\details{
There are several possibilities, depending on the object \code{type}, as
listed below. Note that these possibilities are checked in the
order listed here.
\enumerate{
\item For all object types:
\enumerate{
\item If \code{i} is \code{"metadata"} then the \code{metadata} slot of \code{x} is returned.
\item Otherwise, if \code{i} is \code{"data"} then the \code{data} slot of \code{x} is returned.
\item Otherwise, if \code{i} is \code{"cycle"} then a character vector of the cycle
numbers is returned.
\item Otherwise, if \code{i} is \code{"processingLog"} then the \code{processingLog} slot of
\code{x} is returned.
\item Otherwise, if \code{i} is \code{"ID"} then a character vector of the ID numbers
is returned.
\item Otherwise, the following steps are taken, depending on \code{type}.
}
\item If \code{type} is \code{"index"}, i.e. if \code{x} was created with \code{\link[=getIndex]{getIndex()}}
or with \code{\link[=subset,argoFloats-method]{subset,argoFloats-method()}} acting on the result of \code{\link[=getIndex]{getIndex()}},
then:
\enumerate{
\item If \code{i} is numeric and \code{j} is unspecified, then \code{i} is taken to
be an index that identifies the row(s) of the data frame that
was constructed by \code{\link[=getIndex]{getIndex()}} based on the remote index file
downloaded from the Argo server.  This has elements \code{file} for
the remote file name, \code{date} for the date of the entry, \code{latitude}
and \code{longitude} for the float position, etc.
\item If \code{i} is the name of an item in the \code{metadata} slot, then that item
is returned. The choices are:
\code{"destdir"}, \code{"destfileRda"}, \code{"filename"}, \code{"ftpRoot"}, \code{"header"},
\code{"server"}, \code{"type"}, and \code{"url"}.
\item Otherwise, if \code{i} is the name of an item in the \code{data} slot, then that item
is returned.  The choices are:
\code{"date"}, \code{"date_update"}, \code{"file"}, \code{"institution"}, \code{"latitude"},
\code{"longitude"}, \code{"ocean"}, and \code{"profiler_type"}. Note that \code{"time"} and
\code{"time_update"} may be used as synonyms for \code{"date"} and \code{"date_update"}.
\item Otherwise, if \code{i=="index"} then that item from the \code{data} slot of \code{x} is returned.
(For the possible names, see the previous item in this sub-list.)
\item Otherwise, if \code{i} is an integer, then the \code{i}-th row of the \code{index} item in
the \code{data} slot is returned.  This is a good way to learn the
longitude and latitude of the profile, the file name on the server,
etc.
\item Otherwise, if \code{i} is \code{"ID"} then the return value is developed from the
\code{index$file} item within the \code{data} slot of \code{x}, in one of three cases:
\enumerate{
\item If \code{j} is not supplied, the return value is a vector holding the
identifiers (character codes for numbers) for all the data files
referred to in the index.
\item Otherwise, if \code{j} is numeric, then the return value is a subset of
the ID codes, as indexed by \code{j}.
\item Otherwise, an error is reported.
}
\item If \code{i} is \code{"length"}, the number of remote files pointed to by the index
is returned.
}
\item Otherwise, if \code{type} is \code{"profiles"}, i.e. if \code{x} was created with \code{\link[=getProfiles]{getProfiles()}}, then:
\enumerate{
\item If \code{i} is numeric and \code{j} is unspecified, then return the local file name(s)
that are identified by using \code{i} as an index.
\item If \code{i} is the name of an item in the \code{metadata} slot, then that item
is returned. The choices are:
\code{"type"} and \code{"destdir"}.
\item Otherwise, if \code{i} is the name of an item in the \code{data} slot, then that item
is returned.  There is only one choice: \code{"file"}.
\item If \code{i} is \code{"length"}, the number of local file names that were downloaded
by \code{\link[=getProfiles]{getProfiles()}} is returned.
}
\item Otherwise, if \code{type} is \code{"argos"}, i.e. if \code{x} was created with \code{\link[=readProfiles]{readProfiles()}}, then:
\enumerate{
\item If \code{i} is equal to \code{"argos"}, and \code{j} is unspecified, then a list
holding the \link[oce:argo-class]{oce::argo} objects stored within \code{x} is returned.
\item If \code{i} is equal to \code{"argos"}, and \code{j} is provided, then the associated
\link[oce:argo-class]{oce::argo} object is returned.
\item If \code{i} is numeric and \code{j} is unspecified, then return the argo objects identified
by using \code{i} as an index.
\item If \code{i} is the name of an item in the \code{metadata} slot, then that item
is returned. There is only choice, \code{"type"}.
\item Otherwise, if \code{i} is the name of an item in the \code{data} slot, then that item
is returned as a named list.  (At present, there is only one choice: \code{"argos"}.)
\item Otherwise, if \code{i} is \code{"length"} then the number of oce-type argo objects in \code{x} is returned.
\item Otherwise, if \code{i} is a character value then it is taken to be
an item within the \code{metadata} or \code{data} slots of the argo objects
stored in \code{x}, and the returned value is a list containing that
information with one (unnamed) item per profile.
If \code{j} is provided
and equal to \code{"byLevel"}, then the items from the \code{metadata} are
repeated (if necessary) and formed into matrix or vector of the same
shape as the \code{"pressure"} field; this can be convenient for computations
involving items that only occur once per profile, such as \code{"longitude"},
but it should not be used for items that are not level-specific, such
as the various \code{"HISTORY_*"} elements, which apply to a dataset, not to
a level
\item Otherwise, NULL is reported.
}
\item Otherwise, an error is reported.
}
}
\examples{
data(index)
# Full remote filename for first two item in index
paste0(index[["server"]], "/dac/", index[["cycle", 1:2]])
# File names and geographical locations of first 5 items in index
index5 <- subset(index, 1:5)
data.frame(file=gsub(".*/", "", index5[["file"]][1]),
           lon=index5[["longitude"]],
           lat=index5[["latitude"]])

}
\references{
Kelley, D. E., Harbin, J., & Richards, C. (2021). argoFloats: An R package for analyzing
Argo data. Frontiers in Marine Science, (8), 636922.
\doi{10.3389/fmars.2021.635922}
}
\author{
Dan Kelley
}
