% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdlp2.R
\name{applyCut}
\alias{applyCut}
\title{Apply Cut Points to Vector}
\usage{
applyCut(col, cuts, infinite_bounds, labels)
}
\arguments{
\item{col}{input vector with data.}

\item{cuts}{vector with cutpoints.
There are several special values defined:
\code{NULL} indicates that no discretization will be performed, but the value will be converted to factor
 \code{"All"} indicates all values will be merged into one.}

\item{infinite_bounds}{a logical indicating how the bounds on the extremes should look like.
If set to \code{FALSE}, the leftmost/rightmost intervals will be bounded by the minimum and maximum in the respective column.
If set to \code{TRUE}, the leftmost/rightmost intervals will be bounded by negative and positive infinity.}

\item{labels}{a logical indicating whether the bins of the discretized data should be represented by integer codes or as interval notation using (a;b] when set to TRUE.}
}
\value{
Vector with discretized data.
}
\description{
Applies cut points to vector.
}
\examples{
  applyCut(datasets::iris[[1]], c(3,6), TRUE, TRUE)
}
\seealso{
\code{\link{applyCuts}}
}
