% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arakno.R
\name{lsid}
\alias{lsid}
\title{Get species LSID from WSC.}
\usage{
lsid(tax, order = FALSE)
}
\arguments{
\item{tax}{A taxon name or vector with taxa names.}

\item{order}{Order taxa names alphabetically or keep as in tax.}
}
\value{
A data.frame with species and LSID.
}
\description{
Get species LSID from the World Spider Catalogue.
}
\details{
This function will get species LSID from the World Spider Catalogue (2022). Family and genera names will be converted to species.
}
\examples{
\dontrun{
lsid("Anapistula")
lsid(tax = c("Iberesia machadoi", "Nemesia bacelarae", "Amphiledorus ungoliantae"), order = TRUE)
}
}
\references{
World Spider Catalog (2022). World Spider Catalog. Version 23.0. Natural History Museum Bern, online at http://wsc.nmbe.ch. doi: 10.24436/2.
}
