% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz.R
\name{sedona_visualization_routines}
\alias{sedona_visualization_routines}
\title{Visualization routine for Sedona spatial RDD.}
\arguments{
\item{rdd}{A Sedona spatial RDD.}

\item{resolution_x}{Resolution on the x-axis.}

\item{resolution_y}{Resolution on the y-axis.}

\item{output_location}{Location of the output image. This should be the
desired path of the image file excluding extension in its file name.}

\item{output_format}{File format of the output image. Currently "png",
"gif", and "svg" formats are supported (default: "png").}

\item{boundary}{Only render data within the given rectangular boundary.
The `boundary` parameter can be set to either a numeric vector of
c(min_x, max_y, min_y, max_y) values, or with a bounding box object
e.g., new_bounding_box(sc, min_x, max_y, min_y, max_y), or NULL
(the default). If `boundary` is NULL, then the minimum bounding box of the
input spatial RDD will be computed and used as boundary for rendering.}

\item{color_of_variation}{Which color channel will vary depending on values
of data points. Must be one of "red", "green", or "blue". Default: red.}

\item{base_color}{Color of any data point with value 0. Must be a numeric
vector of length 3 specifying values for red, green, and blue channels.
Default: c(0, 0, 0).}

\item{shade}{Whether data point with larger magnitude will be displayed with
darker color. Default: TRUE.}

\item{overlay}{A \code{viz_op} object containing a raster image to be
displayed on top of the resulting image.}

\item{browse}{Whether to open the rendered image in a browser (default:
interactive()).}
}
\description{
Generate a visual representation of geometrical object(s) within a Sedona
spatial RDD.
}
