% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pod_analysis.R
\name{plot_slope_analysis}
\alias{plot_slope_analysis}
\title{Plot the median slope}
\usage{
plot_slope_analysis(pod_slope_data, yaxis_limit = FALSE, yaxis_limit_values)
}
\arguments{
\item{pod_slope_data}{the \code{data.frame} object that contains the
concentration and slope data.}

\item{yaxis_limit}{a \code{boolean} value (default is FALSE) that identifies
if the user wants to specify y-axis limits.}

\item{yaxis_limit_values}{a two-element \code{vector} that specifies the
y-axis limits. For instance \code{yaxis_limit_values = c(0, 20)}.}
}
\description{
This simply plots the slope as a function of concentration.
}
\examples{
bmr_obj <- bootstrap_metaregression(oxybenzone, 15, 100)
slope_pod <- slope_pod_analysis(bmr_obj, 0.0001, 10, 0.1)
plot_slope_analysis(slope_pod, TRUE, c(0,30))
}

