% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper-k-plus-anticlustering.R
\name{kplus_anticlustering}
\alias{kplus_anticlustering}
\title{K-plus anticlustering}
\usage{
kplus_anticlustering(
  x,
  K,
  variance = TRUE,
  skew = FALSE,
  kurtosis = FALSE,
  covariances = FALSE,
  moments = NULL,
  standardize = TRUE,
  ...
)
}
\arguments{
\item{x}{A feature matrix where rows correspond to elements and columns
correspond to variables (a single numeric variable can be
passed as a vector).}

\item{K}{How many anticlusters should be created. Alternatively:
(a) A vector describing the size of each group, or (b) a vector
of length \code{nrow(x)} describing how elements are assigned
to anticlusters before the optimization starts.}

\item{variance}{Boolean: Should the k-plus objective include a term to 
maximizie between-group similarity with regard to the variance? 
(Default = TRUE)}

\item{skew}{Boolean: Should the k-plus objective include a term to 
maximizie between-group similarity with regard to skewness? 
(Default = FALSE)}

\item{kurtosis}{Boolean: Should the k-plus objective include a term to 
maximizie between-group similarity with regard to kurtosis? 
(Default = FALSE)}

\item{covariances}{Boolean: Should the k-plus objective include a term to 
maximizie between-group similarity with regard to covariance structure? 
(Default = FALSE)}

\item{moments}{Optional argument: An integer vector specifying which 
distribution moments should be equalized between groups.}

\item{standardize}{Boolean. If \code{TRUE}, the data is standardized through 
a call to \code{\link{scale}} before the optimization starts. 
Defaults to TRUE. See details.}

\item{...}{Arguments passed down to \code{\link{anticlustering}}. All of the 
arguments are supported except for \code{objective}.}
}
\description{
Perform anticlustering using the k-plus objective to maximize between-group 
similarity. This function implements the k-plus anticlustering method described 
Papenberg (2023; <doi:10.31234/osf.io/7jw6v>).
}
\details{
If the argument \code{moments} is used, it overrides the arguments
    \code{variance}, \code{skew} and \code{kurtosis} (corresponding to
    the second, third and fourth moment), ignoring their values. Note that 
    the first moment, i.e., the mean is always included in the optimization
    (corresponding to the standard k-means criterion); it cannot be "turned off"
    by using the argument \code{moments}.
    
    The \code{standardization} is applied to all original features and the 
    additional features that are appended in order to optimize 
    the k-plus criterion (this means that all criteria such as means, 
    variances, skewness etc. receive the same relative weight 
    during the optimization.)
   
    This function can use any arguments that are also possible in 
    \code{\link{anticlustering}}
    (except for `objective` of course; because the objective optimized here
    is the k-plus objective -- to use a different objective, 
    call \code{\link{anticlustering}} directly). Any arguments that are
    not explicitly changed here (i.e., \code{standardize = TRUE}) receive the 
    default given in \code{\link{anticlustering}} 
    (e.g., `method = "exchange"`.)
}
\examples{

# Generate some data
N <- 180
M <- 4
features <- matrix(rnorm(N * M), ncol = M)
plot(features)
# standard k-plus anticlustering: optimize similarity with regard to mean
# and variance:
cl <- kplus_anticlustering(features, K = 3, method = "local-maximum")
mean_sd_tab(features, cl)

# Also optimize with regard to skewness and kurtosis
cl2 <- kplus_anticlustering(
  features, 
  K = 3, 
  method = "local-maximum", 
  skew = TRUE, 
  kurtosis = TRUE
)

# Try to equalize the first 10 moments between groups (the first moment, 
# i.e., the mean, is always considered in k-plus anticlustering)
kplus_anticlustering(
  features, 
  K = 3, 
  moments = 2:10, 
)
}
\references{
Papenberg, M. (2023). k-plus Anticlustering: An Improved k-means Criterion 
for Maximizing Between-Group Similarity. Retrieved from psyarxiv.com/7jw6v
}
