% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anglr-package.R
\docType{data}
\name{gebco}
\alias{gebco}
\title{world elevation raster}
\description{
A simple raster map of world topography, elevation relative to sea level in
metres. Source data is Gebco 2014, converted to a much reduced 1 degree
resolution global map.
}
\details{
Data downloaded from GEBCO 2014 (0.0083 degrees = 30sec arcmin resolution)
and set at resolution 1 degrees.
\href{https://www.gebco.net/data_and_products/gridded_bathymetry_data/}{GEBCO 2014}.
}
\examples{
data("gebco", package = "anglr")
library(silicate)
laea <- "+proj=laea +lon_0=147 +lat_0=-42"
longlat <- "+proj=longlat +datum=WGS84"
x <- SC(simpleworld) \%>\% copy_down(gebco + 500)
plot3d(x); rgl::aspect3d(1, 1, 0.07)
}
