% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wire3d.R
\name{wire3d}
\alias{wire3d}
\alias{wire3d.sc}
\alias{wire3d.TRI}
\alias{wire3d.TRI0}
\alias{wire3d.DEL}
\alias{wire3d.DEL0}
\alias{wire3d.QUAD}
\alias{wire3d.matrix}
\alias{wire3d.sf}
\alias{wire3d.Spatial}
\alias{wire3d.triangulation}
\alias{wire3d.trip}
\alias{wire3d.BasicRaster}
\title{Draw a mesh as line segments in 3D}
\usage{
\method{wire3d}{sc}(x, ...)

\method{wire3d}{TRI}(x, ...)

\method{wire3d}{TRI0}(x, ...)

\method{wire3d}{DEL}(x, ...)

\method{wire3d}{DEL0}(x, ...)

\method{wire3d}{QUAD}(x, ...)

\method{wire3d}{matrix}(x, ...)

\method{wire3d}{sf}(x, ...)

\method{wire3d}{Spatial}(x, ...)

\method{wire3d}{triangulation}(x, ...)

\method{wire3d}{trip}(x, ...)

\method{wire3d}{BasicRaster}(x, ...)
}
\arguments{
\item{x}{sp, sf, raster, trip, or any other model understood by anglr/silicate}

\item{...}{pass \link[rgl:rgl.material]{material3d properties} to rgl}
}
\description{
Draw line segments with rgl from any \link[rgl:tmesh3d]{shape3d} classed object. Produces
a 3D scatterplot like that produced by \code{\link[rgl:plot3d]{rgl::plot3d()}}, but from a mesh-alike
object.
}
\details{
Objects that are not explicitly surfaces will be triangulated in order to produce the
mesh. Whether this is a good idea or not is an open question.

It is not currently \emph{technically defined or clear} how colour properties are
mapped to line segments by default ... there is a problem of what property to
use from features that share the same vertex or edge, and we have put that
aside and erred on the side of inaccuracy in favour of getting a pretty plot
(hopefully). (Properties that come later - lower rows - win, I think.
}
\seealso{
\link{plot3d} \link{as.mesh3d} \link{persp3d} \link{dot3d} \link{shade3d}
}
