% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariates.R
\name{calc_nei}
\alias{calc_nei}
\title{Calculate road emissions covariates}
\usage{
calc_nei(from = NULL, locs = NULL, locs_id = "site_id", geom = FALSE, ...)
}
\arguments{
\item{from}{SpatVector(1). Output of \code{process_nei()}.}

\item{locs}{sf/SpatVector. Locations at NEI values are joined.}

\item{locs_id}{character(1). Unique site identifier column name.
Unused but kept for compatibility.}

\item{geom}{logical(1). Should the function return a \code{SpatVector}?
Default is \code{FALSE}. The coordinate reference system of the \code{SpatVector} is
that of \code{from.}}

\item{...}{Placeholders.}
}
\value{
a data.frame or SpatVector object
}
\description{
Calculate road emissions covariates
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
loc <- data.frame(id = "001", lon = -78.90, lat = 35.97)
calc_nei(
  from = nei, # derived from process_nei example
  locs = loc,
  locs_id = "id"
)
}
}
\seealso{
\code{\link{process_nei}}
}
\author{
Insang Song, Ranadeep Daw
}
