% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{get_app}
\alias{get_app}
\title{Get Applications}
\usage{
get_app(request_params = list(), gallery = get_gallery())
}
\arguments{
\item{request_params}{List of app search parameters. For more information on
parameters, visit the Alteryx Gallery API documentation
\url{https://gallery.alteryx.com/api-docs/} and see the parameters under the
'Find workflows in a subscription' section.}

\item{gallery}{URL for your Alteryx Gallery}
}
\value{
\code{get_app} returns a \code{list} of \code{alteryx_app}s
}
\description{
An Alteryx application is a workflow that has been designed to
run based on user input to questions. In order to run these resources using
\code{alterryx} you must first obtain the application that you want to run.

To search the workflows you can access from your studio (subscription), use
\code{get_app}. Subscription is tied to API key. You cannot request
workflows for any other subscription without that subscription's API keys.
}
\section{WARNING}{

\code{get_app} will return all resources in the Gallery tied to your
subscription including macros and workflows in addition to applications. You
cannot run workflows or macros using the Alteryx Gallery API and if you try
to do so you will receive an error.
}

\examples{
\dontrun{
# get the five most recently uploaded apps in your studio

request_params <- list(
  packageType = "0",
  limit = "5",
  sortField = "uploaddate"
)

get_app(request_params)
}

}
