% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kappa4nls.R
\name{kappa4nls}
\alias{kappa4nls}
\alias{kappa4nls.default}
\alias{print.kappa4nls}
\alias{summary.kappa4nls}
\alias{print.summary.kappa4nls}
\alias{kappa4nls.formula}
\alias{predict.kappa4nls}
\title{Sigmoidal curve fitting.}
\usage{
kappa4nls(formula, data = list(), lower, upper, tol, maxiter, ...)

\method{kappa4nls}{default}(formula, data = list(), lower = c(0, -5, -5),
  upper = c(10, 1, 1), tol = 1e-15, maxiter = 50000, ...)

\method{print}{kappa4nls}(x, ...)

\method{summary}{kappa4nls}(object, ...)

\method{print}{summary.kappa4nls}(x, ...)

\method{kappa4nls}{formula}(formula, data = list(), lower = c(0, -5, -5),
  upper = c(10, 1, 1), tol = 1e-15, maxiter = 50000, ...)

\method{predict}{kappa4nls}(object, newdata = NULL, ...)
}
\arguments{
\item{formula}{An LHS ~ RHS formula, specifying the linear model to be estimated.}

\item{data}{A data.frame which contains the variables in \code{formula}.}

\item{lower}{A vector of lower constraints for the parameters to be estimated; defaults to c(0, -5, -5).}

\item{upper}{A vector of upper constraints for the parameters to be estimated; defaults to c(10, 1, 1).}

\item{tol}{Error tolerance level; defaults to 1e-15.}

\item{maxiter}{The maximum number of iterations allowed; defaults to 50000.}

\item{...}{Arguments to be passed on to the differential evolution function \code{\link{JDEoptim}}.}

\item{x}{A kappa4nls object.}

\item{object}{A kappa4nls object.}

\item{newdata}{The data on which the estimated model is to be fitted.}
}
\value{
A generic S3 object with class kappa4nls.

kappa4nls.default: A list with all components from \code{\link{JDEoptim}}, as well as:
\itemize{
\item intercept: Did the model contain an intercept TRUE/FALSE?
\item coefficients: A vector of estimated coefficients.
\item error: The value of the objective function.
\item fitted.values: A vector of estimated values.
\item residuals: The residuals resulting from the fitted model.
\item call: The call to the function.
}

summary.kappa4nls: A list of class summary.kappa4nls with the following components:
\itemize{
\item call: Original call to \code{kappa4nls} function.
\item coefficients: A vector with parameter estimates.
\item r.squared: The \eqn{r^{2}} coefficient.
\item sigma: The residual standard error.
\item error: Value of the objective function.
\item residSum: Summary statistics for the distribution of the residuals.
}

print.summary.kappa4nls: The object passed to the function is returned invisibly.

predict.kappa4nls: A vector of predicted values resulting from the estimated model.
}
\description{
A framework for nonlinear least squares fitting of the four-parameter kappa sigmoidal function.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default method for kappa4nls.

\item \code{kappa4nls}: print method for kappa4nls.

\item \code{kappa4nls}: summary method for kappa4nls.

\item \code{summary.kappa4nls}: print method for summary.kappa4nls.

\item \code{formula}: formula method for kappa4nls.

\item \code{kappa4nls}: predict method for kappa4nls.
}}

\examples{
k <- kappa4tc(-4, 0, 1)$par
x <- seq(qkappa4(0, 4, 0.4, -4, k), qkappa4(0.7, 4, 0.4, -4, k), length.out=100)
y <- sapply(x, function(i) pkappa4(i, 4, 0.4, -4, k))
kappa4nls.default(y~x, tol=1e-5)

u <- seq(qkappa4(0.1, 4, 0.4, -4, k), qkappa4(0.8, 4, 0.4, -4, k), length.out=100)
v <- sapply(u, function(i) pkappa4(i, 4, 0.4, -4, k))
nls <- kappa4nls(y~x, tol=1e-5)
predict(nls, newdata=data.frame(y=v, x=u))

}
