% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/calendar-gregorian.R
\docType{methods}
\name{fixed_gregorian}
\alias{fixed_gregorian}
\alias{fixed_from_BP}
\alias{fixed_to_BP}
\alias{fixed_from_BC}
\alias{fixed_to_BC}
\alias{fixed_from_BCE}
\alias{fixed_to_BCE}
\alias{fixed_from_AD}
\alias{fixed_to_AD}
\alias{fixed_from_CE}
\alias{fixed_to_CE}
\alias{fixed_from_b2k}
\alias{fixed_to_b2k}
\title{\emph{Rata Die} Conversion to and from Gregorian Years}
\usage{
fixed_from_BP(year, month, day)

fixed_to_BP(object)

fixed_from_BC(year, month, day)

fixed_to_BC(object)

fixed_from_BCE(year, month, day)

fixed_to_BCE(object)

fixed_from_AD(year, month, day)

fixed_to_AD(object)

fixed_from_CE(year, month, day)

fixed_to_CE(object)

fixed_from_b2k(year, month, day)

fixed_to_b2k(object)
}
\arguments{
\item{year}{A \code{\link{numeric}} vector of years. If \code{month} and \code{day} are missing,
decimal years are expected.}

\item{month}{A \code{\link{numeric}} vector of months.}

\item{day}{A \code{\link{numeric}} vector of days.}

\item{object}{A \code{\linkS4class{RataDie}} object (see \code{\link[=fixed]{fixed()}}).}
}
\value{
\itemize{
\item \verb{fixed_from_*()} returns a \code{\linkS4class{RataDie}} object.
\item \verb{fixed_to_*()} returns a \code{\link{numeric}} vector of Gregorian years.
}
}
\description{
Convenient functions for conversion from and to \emph{rata die} for a given
Gregorian era.
}
\details{
The astronomical notation is used for Gregorian years (there \emph{is} a year 0).
}
\examples{
## R 1.0.0
(y <- fixed(year = 2000, month = 02, day = 29, calendar = CE()))
as_date(y, calendar = CE())
as_year(y, calendar = CE())

## Create a vector of years BP (Gregorian)
## (every two years starting from 2000 BP)
(years <- seq(from = 2000, by = -2, length.out = 10))
## Convert years to rata die
(rd <- fixed(years, calendar = BP()))
## Convert back to Gregorian years BP
as_year(rd, calendar = BP())

## More convenient
(rd <- fixed_from_BP(years))
fixed_to_BP(rd)
}
\references{
Reingold, E. M. and Dershowitz, N. (2018). \emph{Calendrical Calculations:
The Ultimate Edition}. Cambridge University Press.
\doi{10.1017/9781107415058}.
}
\seealso{
Other fixed date tools: 
\code{\link{arithmetic}},
\code{\link{as_date}()},
\code{\link{as_decimal}()},
\code{\link{as_fixed}()},
\code{\link{as_year}()},
\code{\link{fixed}()},
\code{\link{fixed_julian}},
\code{\link{format}()},
\code{\link{pretty}()}
}
\author{
N. Frerebeau
}
\concept{fixed date tools}
