% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot}
\alias{autoplot}
\alias{autoplot.aedseo_tsd}
\alias{autoplot.aedseo}
\title{Create a complete 'ggplot' appropriate to a particular data type}
\usage{
autoplot(object, ...)

\method{autoplot}{aedseo_tsd}(object, ...)

\method{autoplot}{aedseo}(object, linewidth = 0.7, alpha = 0.3, ...)
}
\arguments{
\item{object}{An \code{aedseo_tsd} or \code{aedseo} object}

\item{...}{Additional arguments (not used).}

\item{linewidth}{Numeric, the width of the line for the growth rate}

\item{alpha}{Numeric, the alpha (transparency) for the confidence interval
ribbon}
}
\value{
A 'ggplot' object for visualizing the time series data.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function generates a complete 'ggplot' object suitable for
visualizing time series data in an \code{aedseo_tsd} object. It creates a line
plot connecting the observations and adds points at each data point.
}
\examples{
# Create an example aedseo_tsd object
aedseo_tsd_object <- tsd(
  observed = c(100, 120, 150, 180, 220, 270),
  time = as.Date(c(
    "2023-01-01",
    "2023-01-02",
    "2023-01-03",
    "2023-01-04",
    "2023-01-05",
    "2023-01-06"
  )),
  time_interval = "day"
)

# Create a ggplot visualization for the aedseo_tsd object
autoplot(aedseo_tsd_object)

# Create an aedseo object
aedseo_object <- aedseo(
  tsd = aedseo_tsd_object,
  k = 3,
  level = 0.95,
  family = "quasipoisson"
)

# Create a ggplot visualization of growth rates with confidence intervals
autoplot(aedseo_object, linewidth = 1, alpha = 0.2)
}
