% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aedseo.R
\name{aedseo}
\alias{aedseo}
\title{Automated and Early Detection of Seasonal Epidemic Onset}
\usage{
aedseo(
  tsd,
  k = 5,
  level = 0.95,
  disease_threshold = NA_integer_,
  family = c("poisson", "quasipoisson")
)
}
\arguments{
\item{tsd}{A \code{aedseo_tsd} object containing time series data with 'time' and
'observed.'}

\item{k}{An integer specifying the window size for modeling growth rates.}

\item{level}{The confidence level for parameter estimates, a numeric value
between 0 and 1.}

\item{disease_threshold}{An integer specifying the threshold for considering
a disease outbreak.}

\item{family}{A character string specifying the family for modeling.
Choose between "poisson," or "quasipoisson".}
}
\value{
A \code{aedseo} object containing:
\itemize{
\item 'reference_time': The time point for which the growth rate is estimated.
\item 'observed': The observed value in the reference time point.
\item 'growth_rate': The estimated growth rate.
\item 'lower_growth_rate': The lower bound of the growth rate's confidence
interval.
\item 'upper_growth_rate': The upper bound of the growth rate's confidence
interval.
\item 'growth_warning': Logical. Is the growth rate significantly higher than
zero?
\item 'sum_of_cases': The sum of cases within the time window.
\item 'sum_of_cases_warning': Logical. Does the Sum of Cases exceed the
disease threshold?
\item 'seasonal_onset_alarm': Logical. Is there a seasonal onset alarm?
\item 'converged': Logical. Was the IWLS judged to have converged?
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function performs automated and early detection of seasonal epidemic
onsets (aedseo) on a time series dataset. It estimates growth rates for
consecutive time intervals and calculates the sum of cases (sum_of_cases).
}
\examples{
# Create a tsibble object from sample data
tsd_data <- tsd(
  observed = c(100, 120, 150, 180, 220, 270),
  time = as.Date(c(
    "2023-01-01",
    "2023-01-02",
    "2023-01-03",
    "2023-01-04",
    "2023-01-05",
    "2023-01-06"
  )),
  time_interval = "day"
)

# Calculate AEDSEO with a 3-day window and a Poisson family model
aedseo_results <- aedseo(
  tsd = tsd_data,
  k = 3,
  level = 0.95,
  disease_threshold = 200,
  family = "poisson"
)

# Print the AEDSEO results
print(aedseo_results)
}
