% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nuts.R
\name{sample_tmb_nuts}
\alias{sample_tmb_nuts}
\title{Draw MCMC samples from a model posterior using the No-U-Turn (NUTS)
sampler with dual averaging.}
\usage{
sample_tmb_nuts(iter, fn, gr, init, warmup = floor(iter/2), chain = 1,
  thin = 1, seed = NULL, control = NULL)
}
\arguments{
\item{iter}{The number of samples to draw.}

\item{fn}{A function that returns the log of the posterior density.}

\item{gr}{A function that returns a vector of gradients of the log of
the posterior density (same as \code{fn}).}

\item{init}{A list of lists containing the initial parameter vectors,
one for each chain or a function. It is strongly recommended to
initialize multiple chains from dispersed points. A of NULL signifies
to use the starting values present in the model (i.e., \code{obj$par})
for all chains.}

\item{warmup}{The number of warmup iterations.}

\item{chain}{The chain number, for printing only.}

\item{thin}{The thinning rate to apply to samples. Typically not used
with NUTS.}

\item{seed}{The random seed to use.}

\item{control}{A list to control the sampler. See details for further
use.}
}
\description{
Draw MCMC samples from a model posterior using the No-U-Turn (NUTS)
sampler with dual averaging.
}
\details{
This function implements algorithm 6 of Hoffman and Gelman
  (2014), which includes adaptive step sizes (\code{eps}) via an
  algorithm called dual averaging. It also includes an adaptation scheme
  to tune a diagonal mass matrix (metric) during warmup.

These \code{fn} and \code{gr} functions must have Jacobians already
  applied if there are transformations used.
}
\references{
Hoffman and Gelman (2014). The No-U-Turn sampler: Adaptively setting
  path lengths in Hamiltonian Monte Carlo. J. Mach. Learn. Res.
  15:1593-1623.
}
\seealso{
\code{sample_tmb}
}
