% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hs.R
\name{Hs.test}
\alias{Hs.test}
\title{Test differences in expected heterozygosity (Hs)}
\usage{
Hs.test(x, y, n.sim = 999, alter = c("two-sided", "greater", "less"))
}
\arguments{
\item{x}{a \linkS4class{genind} object.}

\item{y}{a \linkS4class{genind} object.}

\item{n.sim}{the number of permutations to be used to generate the reference distribution.}

\item{alter}{a character string indicating the alternative hypothesis}
}
\value{
an object of the class randtest
}
\description{
This procedure permits to test if two groups have
significant differences in expected heterozygosity (Hs).
The test statistic used is simply the difference in Hs
between the two groups 'x' and 'y':
}
\details{
\eqn{Hs(x) - Hs(y)}

Individuals are randomly permuted between groups to obtain
a reference distribution of the test statistics.
}
\examples{
\dontrun{
data(microbov)
Hs(microbov)
test <- Hs.test(microbov[pop="Borgou"],
                microbov[pop="Lagunaire"],
                n.sim=499)
test
plot(test)
}

}
\seealso{
\code{\link{Hs}} to compute Hs for different populations;
\code{\link[ade4]{as.randtest}} for the class of Monte Carlo tests.
}
\author{
Thibaut Jombart \email{t.jombart@imperial.ac.uk}
}
