% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_results.R
\name{extract_results}
\alias{extract_results}
\title{Extract simulation results}
\usage{
extract_results(
  object,
  select_strategy = "control if available",
  select_last_arm = FALSE,
  select_preferences = NULL,
  te_comp = NULL,
  raw_ests = FALSE
)
}
\arguments{
\item{object}{\code{trial_results} object, output from the \link{run_trials} function.}

\item{select_strategy}{single character string. For trials not stopped
due to superiority (or with only 1 arm remaining, if \code{select_last_arm} is
set to \code{TRUE} in trial designs with a common \code{control} arm; see below),
this parameter specifies which arm will be considered selected when
calculating trial design performance metrics (described below;
this corresponds to the consequence of an inconclusive trial, i.e., which
arm would then be used in practice).\cr
The following options are available and must be written exactly as below
(case sensitive, cannot be abbreviated):
\itemize{
\item \code{"control if available"} (default): selects the \strong{first}
\code{control} arm for trials with a common control arm \emph{\strong{if}} this arm
is active at end-of-trial, otherwise no arm will be selected. For
trial designs without a common \code{control}, no arm will be selected.
\item \code{"none"}: selects no arm in trials not ending with superiority.
\item \code{"control"}: similar to \code{"control if available"}, but will throw
an error for trial designs without a common \code{control} arm.
\item \code{"final control"}: selects the \strong{final} \code{control} arm regardless
of whether the trial was stopped for practical equivalence, futility,
or at the maximum sample size; this strategy can only be specified
for trial designs with a common \code{control} arm.
\item \code{"control or best"}: selects the \strong{first} \code{control} arm if still
active at end-of-trial, otherwise selects the best remaining arm
(defined as the remaining arm with the highest probability of being
the best in the final analysis). Only works for trial designs with a
common \code{control} arm.
\item \code{"best"}: selects the best remaining arm (as described under
\code{"control or best"}).
\item \code{"list or best"}: selects the first remaining arm from a specified
list (specified using \code{select_preferences}, technically a character
vector). If none of these arms are are active at end-of-trial, the best
remaining arm will be selected (as described above).
\item \code{"list"}: as specified above, but if no arms on the provided list
remain active at end-of-trial, no arm is selected.
}}

\item{select_last_arm}{single logical, defaults to \code{FALSE}. If \code{TRUE}, the
only remaining active arm (the last \code{control}) will be selected in trials
with a common \code{control} arm ending with \code{equivalence} or \code{futility}, before
considering the options specified in \code{select_strategy}. Must be \code{FALSE} for
trial designs without a common \code{control} arm.}

\item{select_preferences}{character vector specifying a number of arms used
for selection if one of the \code{"list or best"} or \code{"list"} options are
specified for \code{select_strategy}. Can only contain valid \code{arms}
available in the trial.}

\item{te_comp}{character string, treatment-effect comparator. Can be either
\code{NULL} (the default) in which case the \strong{first} \code{control} arm is used for
trial designs with a common control arm, or a single trial \code{arm}. Will be
used when calculating \code{sq_err_te} (the squared error of the treatment
effect comparing the selected arm to the comparator arm, as described
below).}

\item{raw_ests}{single logical. If \code{FALSE} (default), the
posterior estimates (\code{post_ests}, see \link{setup_trial} and
\link{run_trial}) will be used to calculate \code{sq_err} (the squared error of the
estimated compared to the specified effect in the selected arm) and
\code{sq_err_te} (the squared error of the treatment effect comparing the
selected arm to the comparator arm, as described for \code{te_comp} and below).
If \code{TRUE}, the raw estimates (\code{raw_ests}, see \link{setup_trial} and
\link{run_trial}) will be used instead of the posterior estimates.}
}
\value{
A \code{data.frame} containing the following columns:
\itemize{
\item \code{sim}: the simulation number (from 1 to the number of simulations).
\item \code{final_n}: the final sample size in each simulation.
\item \code{sum_ys}: the sum of the total counts in all arms, e.g., the total
number of events in trials with a binary outcome (\link{setup_trial_binom})
or the sum of the arm totals in trials with a continuous outcome
(\link{setup_trial_norm}).
\item \code{ratio_ys}: calculated as \code{sum_ys/final_n}.
\item \code{final_status}: the final trial status for each simulation, either
\code{"superiority"}, \code{"equivalence"}, \code{"futility"}, or \code{"max"}, as
described in \link{run_trial}.
\item \code{superior_arm}: the final superior arm in simulations stopped for
superiority, will be \code{NA} in simulations not stopped for superiority.
\item \code{selected_arm}: the final selected arm (as described above), will
correspond to the \code{superior_arm} in simulations stopped for superiority
and be \code{NA} if no arm is selected. See \code{select_strategy} above.
\item \verb{sq_err:} the squared error of the estimate in the selected arm,
calculated as \verb{(estimated effect - true effect)^2} for the selected
arms.
\item \code{sq_err_te}: the squared error of the treatment effect comparing
the selected arm to the comparator arm (as specified in \code{te_comp}).
Calculated as:\cr
\verb{((estimated effect in the selected arm - estimated effect in the comparator arm) -}
\verb{(true effect in the selected arm - true effect in the comparator arm))^2} \cr
Will be \code{NA} for simulations without a selected arm or with no
comparator specified (see \code{te_comp} above).
}
}
\description{
This function extracts relevant information from multiple simulations of the
same trial specification in a tidy \code{data.frame} (1 simulation per row).
See also the \link{summary} function.
}
\examples{
# Setup a trial specification
binom_trial <- setup_trial_binom(arms = c("A", "B", "C", "D"),
                                 control = "A",
                                 true_ys = c(0.20, 0.18, 0.22, 0.24),
                                 data_looks = 1:20 * 100)

# Run 10 simulations with a specified random base seed
res <- run_trials(binom_trial, n_rep = 10, base_seed = 12345)

# Extract results and Select the control arm if available
# in simulations not ending with superiority
extract_results(res, select_strategy = "control")

}
